/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;

public class IntegerDataType
extends BasicDataType<Integer> {
    public static final IntegerDataType INSTANCE = new IntegerDataType();
    private static final Integer[] EMPTY_INTEGER_ARR = new Integer[0];

    private IntegerDataType() {
    }

    @Override
    public int getMemory(Integer n) {
        return 4;
    }

    @Override
    public void write(WriteBuffer writeBuffer, Integer n) {
        writeBuffer.putVarInt(n);
    }

    @Override
    public Integer read(ByteBuffer byteBuffer) {
        return DataUtils.readVarInt(byteBuffer);
    }

    public Integer[] createStorage(int n) {
        return n == 0 ? EMPTY_INTEGER_ARR : new Integer[n];
    }

    @Override
    public int compare(Integer n, Integer n2) {
        return Integer.compare(n, n2);
    }

    @Override
    public int binarySearch(Integer n, Object object, int n2, int n3) {
        int n4 = n;
        Integer[] integerArray = (Integer[])this.cast(object);
        int n5 = 0;
        int n6 = n2 - 1;
        int n7 = n3 - 1;
        if (n7 < 0 || n7 > n6) {
            n7 = n6 >>> 1;
        }
        return IntegerDataType.binarySearch(n4, integerArray, n5, n6, n7);
    }

    private static int binarySearch(int n, Integer[] integerArray, int n2, int n3, int n4) {
        while (n2 <= n3) {
            int n5 = integerArray[n4];
            if (n > n5) {
                n2 = n4 + 1;
            } else if (n < n5) {
                n3 = n4 - 1;
            } else {
                return n4;
            }
            n4 = n2 + n3 >>> 1;
        }
        return ~n2;
    }
}

