/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.regex.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.java.hints.regex.parser.RegExParser;

public class RegexConstructs {

    public static class SpecialConstructGroup
    extends Group {
        private GroupType groupType;

        public GroupType getGroupType() {
            return this.groupType;
        }

        public void setGroupType(GroupType groupType) {
            this.groupType = groupType;
        }

        public SpecialConstructGroup(GroupType groupType, RegEx regex) {
            super(regex);
            this.groupType = groupType;
        }
    }

    public static class SpecialChar {
        public static Map<Character, RegEx> sChars = SpecialChar.buildHashMap(Character.valueOf('t'), new Primitive('\t'), Character.valueOf('n'), new Primitive('\n'), Character.valueOf('r'), new Primitive('\r'), Character.valueOf('f'), new Primitive('\f'), Character.valueOf('\\'), new Primitive('\\'), Character.valueOf('s'), SpecialChar.buildWhiteSpaceEscape(false), Character.valueOf('d'), SpecialChar.buildDigitEscape(false), Character.valueOf('w'), SpecialChar.buildAlphaNumericEscape(false), Character.valueOf('S'), SpecialChar.buildWhiteSpaceEscape(true), Character.valueOf('D'), SpecialChar.buildDigitEscape(true), Character.valueOf('W'), SpecialChar.buildAlphaNumericEscape(true));

        public static RegEx buildWhiteSpaceEscape(boolean negation) {
            CharClass charClass = new CharClass(negation, false);
            charClass.addToClass(new Primitive('\t'), new Primitive('\n'), new Primitive('\f'), new Primitive('\r'), new Primitive(' '));
            return charClass;
        }

        public static RegEx buildDigitEscape(boolean negation) {
            CharClass charClass = new CharClass(negation, false);
            charClass.addToClass(new Range('0', '9'));
            return charClass;
        }

        public static RegEx buildAlphaNumericEscape(boolean negation) {
            CharClass charClass = new CharClass(false, false);
            charClass.addToClass(new Range('1', '9'), new Range('a', 'z'), new Range('A', 'Z'), new Primitive('_'));
            return charClass;
        }

        public static HashMap<Character, RegEx> buildHashMap(Object ... data) {
            HashMap<Character, RegEx> result = new HashMap<Character, RegEx>();
            if (data.length % 2 != 0) {
                throw new IllegalArgumentException("Odd number of arguments");
            }
            Character key = null;
            Integer step = -1;
            block4: for (Object value : data) {
                Integer n = step;
                step = step + 1;
                switch (step % 2) {
                    case 0: {
                        if (value == null) {
                            throw new IllegalArgumentException("Null key value");
                        }
                        key = (Character)value;
                        continue block4;
                    }
                    case 1: {
                        result.put(key, (RegEx)value);
                    }
                }
            }
            return result;
        }
    }

    public static class Sequence
    extends RegEx {
        public final RegEx firstSeq;
        public final RegEx secondSeq;

        public Sequence(RegEx first, RegEx second) {
            this.firstSeq = first;
            this.secondSeq = second;
        }
    }

    public static class Repetition
    extends RegEx {
        private RegEx internal;

        public Repetition(RegEx internal) {
            this.internal = internal;
        }

        public RegEx getInternal() {
            return this.internal;
        }
    }

    public static class Range
    extends RegEx {
        private char from;
        private char to;

        public Range(char from, char to) {
            this.from = from;
            this.to = to;
        }

        public char getFrom() {
            return this.from;
        }

        public char getTo() {
            return this.to;
        }
    }

    public static class Primitive
    extends RegEx {
        private char ch;

        public Primitive(char esc) {
            this.ch = esc;
        }

        public char getCh() {
            return this.ch;
        }
    }

    public static class Posix
    extends CharClass {
        private String posixName;

        public Posix(String posixName, boolean isNegation, boolean isIntersection) {
            super(isNegation, isIntersection);
            this.posixName = posixName;
        }

        public String getPosixName() {
            return this.posixName;
        }
    }

    public static class Optional
    extends RegEx {
        private RegEx internal;

        public Optional(RegEx base) {
            this.internal = base;
        }

        public RegEx getInternal() {
            return this.internal;
        }
    }

    public static class OneOrMore
    extends RegEx {
        private RegEx internal;

        public OneOrMore(RegEx base) {
            this.internal = base;
        }

        public RegEx getInternal() {
            return this.internal;
        }
    }

    public static class NamedGroup
    extends CapturingGroup {
        private String groupName;

        public NamedGroup(int groupNo, String groupName, RegEx regex, RegExParser regExParser) {
            super(groupNo, regex, regExParser);
            this.groupName = groupName;
            regExParser.getNamedGroupMap().put(groupName, regex);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }
    }

    public static enum GroupType {
        POSITIVE_LOOKAHEAD,
        NEGATIVE_LOOKAHEAD,
        POSITIVE_LOOKBEHIND,
        NEGATIVE_LOOKBEHIND,
        CAPTURE_GROUP,
        NON_CAPTURE_GROUP;


        public boolean isNegative() {
            return this == NEGATIVE_LOOKAHEAD || this == NEGATIVE_LOOKBEHIND;
        }

        public boolean isPositive() {
            return this == POSITIVE_LOOKAHEAD || this == POSITIVE_LOOKBEHIND;
        }
    }

    public static class Group
    extends RegEx {
        private RegEx internal;

        public Group(RegEx regex) {
            this.internal = regex;
        }

        public RegEx getInternal() {
            return this.internal;
        }

        public void setInternal(RegEx internal) {
            this.internal = internal;
        }
    }

    public static class GreedyBound
    extends RegEx {
        private final RegEx internal;
        private int min;
        private boolean maxPresent;
        private int max;

        public boolean isMaxPresent() {
            return this.maxPresent;
        }

        public void setMaxPresent(boolean maxPresent) {
            this.maxPresent = maxPresent;
        }

        public GreedyBound(RegEx base) {
            this.internal = base;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public RegEx getInternal() {
            return this.internal;
        }
    }

    public static class Concat
    extends RegEx {
        private ArrayList<RegEx> concat;

        public ArrayList<RegEx> getConcat() {
            return this.concat;
        }

        public void setConcat(ArrayList<RegEx> concat) {
            this.concat = concat;
        }

        public Concat(ArrayList<RegEx> seq) {
            this.concat = seq;
        }
    }

    public static class Choice
    extends RegEx {
        private ArrayList<RegEx> choice;

        public Choice(ArrayList<RegEx> choice) {
            this.choice = choice;
        }

        public static Choice subChoices(RegEx ... regex) {
            ArrayList<RegEx> alternatives = new ArrayList<RegEx>();
            for (RegEx r : regex) {
                if (r instanceof Choice) {
                    alternatives.addAll(((Choice)r).getChoice());
                    continue;
                }
                alternatives.add(r);
            }
            return new Choice(alternatives);
        }

        public ArrayList<RegEx> getChoice() {
            return this.choice;
        }

        public void setChoice(ArrayList<RegEx> choice) {
            this.choice = choice;
        }
    }

    public static class CapturingGroup
    extends Group {
        private int groupNo;

        public CapturingGroup(int groupNo, RegEx regex, RegExParser regExParser) {
            super(regex);
            this.groupNo = groupNo;
            regExParser.getGroupMap().put(groupNo, regex);
        }

        public int getGroupNo() {
            return this.groupNo;
        }

        public void setGroupNo(int groupNo) {
            this.groupNo = groupNo;
        }
    }

    public static class CharClass
    extends RegEx {
        private final boolean isNegation;
        private final boolean isIntersection;
        private final List<RegEx> charClassList;
        private final List<Character> allChars;
        private final List<Character> negationChars;

        public CharClass(boolean isNegation, boolean isIntersection) {
            this.isNegation = isNegation;
            this.isIntersection = isIntersection;
            this.charClassList = new ArrayList<RegEx>();
            this.allChars = new ArrayList<Character>();
            this.negationChars = new ArrayList<Character>();
            for (int c = 32; c <= 126; ++c) {
                this.negationChars.add(Character.valueOf((char)c));
            }
        }

        public void addToClass(RegEx ... nextChar) {
            for (RegEx next : nextChar) {
                this.charClassList.add(next);
                if (next instanceof Primitive) {
                    this.allChars.add(Character.valueOf(((Primitive)next).getCh()));
                    this.negationChars.remove(Character.valueOf(((Primitive)next).getCh()));
                    continue;
                }
                if (next instanceof Range) {
                    char from = ((Range)next).getFrom();
                    char to = ((Range)next).getTo();
                    for (char c = from; c <= to; c = (char)(c + '\u0001')) {
                        this.allChars.add(Character.valueOf(c));
                        this.negationChars.remove(Character.valueOf(c));
                    }
                    continue;
                }
                if (!(next instanceof CharClass)) continue;
                CharClass charClass = (CharClass)next;
                if (charClass.isIntersection) {
                    this.handleIntersection(charClass);
                    continue;
                }
                this.handleUnion(charClass);
            }
        }

        private void handleUnion(CharClass charClass) {
            List<Character> allCharInt = charClass.isNegation() ? charClass.getNegationList() : charClass.getAllChar();
            ListIterator<Character> listIterator = allCharInt.listIterator();
            while (listIterator.hasNext()) {
                Character c = listIterator.next();
                if (this.allChars.contains(c)) continue;
                this.allChars.add(c);
                this.negationChars.remove(c);
            }
        }

        private void handleIntersection(CharClass charClass) {
            List<Character> allCharInt = charClass.isNegation() ? charClass.getNegationList() : charClass.getAllChar();
            ListIterator<Character> listIterator = this.allChars.listIterator();
            while (listIterator.hasNext()) {
                Character c = listIterator.next();
                if (allCharInt.contains(c)) continue;
                listIterator.remove();
                this.negationChars.add(c);
            }
        }

        public boolean isNegation() {
            return this.isNegation;
        }

        public List<RegEx> getCharClassList() {
            return this.charClassList;
        }

        public List<Character> getAllChar() {
            return this.allChars;
        }

        public List<Character> getNegationList() {
            return this.negationChars;
        }
    }

    public static class Blank
    extends RegEx {
    }

    public static class AnyChar
    extends RegEx {
    }

    public static abstract class RegEx {
    }
}

