/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LoggerHintsCustomizer
extends JPanel {
    public static final String CUSTOM_LOGGERS_ENABLED = "custom-loggers";
    public static final String CUSTOM_LOGGERS = "custom-loggers-list";
    private Preferences p;
    private final List<String> customLoggersList = new ArrayList<String>();
    private JButton btnAdd;
    private JButton btnRemove;
    private JTextField customLogClass;
    private JList customLoggers;
    private JLabel lblInstructions;
    private JCheckBox loggersCheckbox;
    private JPanel loggersPanel;
    private JScrollPane loggersScrollPane;

    public LoggerHintsCustomizer(Preferences p) {
        this.initComponents();
        this.p = p;
        this.loggersCheckbox.setSelected(p.getBoolean(CUSTOM_LOGGERS_ENABLED, false));
        p.putBoolean(CUSTOM_LOGGERS_ENABLED, this.loggersCheckbox.isSelected());
        this.enableDisablePanel(this.loggersCheckbox.isSelected());
        List<String> loadedValues = this.loadLoggersFromPrefs();
        if (loadedValues != null) {
            this.customLoggersList.addAll(loadedValues);
        }
        this.customLoggers.setListData(this.customLoggersList.toArray());
        this.btnRemove.setEnabled(this.loggersCheckbox.isSelected() && !this.customLoggersList.isEmpty());
    }

    private void enableDisablePanel(boolean enabled) {
        Component[] components;
        this.loggersPanel.setEnabled(enabled);
        for (Component c : components = this.loggersPanel.getComponents()) {
            if (c.equals(this.btnRemove)) continue;
            c.setEnabled(enabled);
        }
        this.btnRemove.setEnabled(enabled && !this.customLoggersList.isEmpty());
        this.loggersScrollPane.getViewport().getView().setEnabled(enabled);
    }

    private void initComponents() {
        this.loggersCheckbox = new JCheckBox();
        this.loggersPanel = new JPanel();
        this.customLogClass = new JTextField();
        this.loggersScrollPane = new JScrollPane();
        this.customLoggers = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lblInstructions = new JLabel();
        this.setPreferredSize(new Dimension(360, 150));
        Mnemonics.setLocalizedText(this.loggersCheckbox, NbBundle.getMessage(LoggerHintsCustomizer.class, "LoggerHintsCustomizer.loggersCheckbox.text"));
        this.loggersCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerHintsCustomizer.this.loggersCheckboxActionPerformed(evt);
            }
        });
        this.loggersPanel.setPreferredSize(new Dimension(360, 121));
        this.customLogClass.setText(NbBundle.getMessage(LoggerHintsCustomizer.class, "LoggerHintsCustomizer.customLogClass.text"));
        this.customLoggers.setSelectionMode(0);
        this.loggersScrollPane.setViewportView(this.customLoggers);
        Mnemonics.setLocalizedText(this.btnAdd, NbBundle.getMessage(LoggerHintsCustomizer.class, "LoggerHintsCustomizer.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerHintsCustomizer.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.btnRemove, NbBundle.getMessage(LoggerHintsCustomizer.class, "LoggerHintsCustomizer.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoggerHintsCustomizer.this.btnRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.lblInstructions, NbBundle.getMessage(LoggerHintsCustomizer.class, "LoggerHintsCustomizer.lblInstructions.text"));
        GroupLayout loggersPanelLayout = new GroupLayout(this.loggersPanel);
        this.loggersPanel.setLayout(loggersPanelLayout);
        loggersPanelLayout.setHorizontalGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loggersPanelLayout.createSequentialGroup().addContainerGap().addGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(loggersPanelLayout.createSequentialGroup().addComponent(this.lblInstructions, -1, -1, Short.MAX_VALUE).addGap(82, 82, 82)).addGroup(loggersPanelLayout.createSequentialGroup().addGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customLogClass).addComponent(this.loggersScrollPane)).addGap(11, 11, 11).addGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnAdd, -2, 71, -2).addComponent(this.btnRemove))))));
        loggersPanelLayout.setVerticalGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loggersPanelLayout.createSequentialGroup().addGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.customLogClass, -2, -1, -2).addComponent(this.btnAdd)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblInstructions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(loggersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loggersScrollPane, -2, 56, -2).addComponent(this.btnRemove)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loggersPanel, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.loggersCheckbox).addContainerGap(115, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loggersCheckbox).addGap(3, 3, 3).addComponent(this.loggersPanel, -2, -1, -2)));
    }

    private void loggersCheckboxActionPerformed(ActionEvent evt) {
        this.enableDisablePanel(this.loggersCheckbox.isSelected());
        this.p.putBoolean(CUSTOM_LOGGERS_ENABLED, this.loggersCheckbox.isSelected());
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        if (this.customLogClass.getText().matches("(\\w+\\.?)+")) {
            if (this.customLoggersList.contains(this.customLogClass.getText())) {
                this.customLogClass.setText("");
                return;
            }
            this.customLoggersList.add(this.customLogClass.getText().trim());
            Collections.sort(this.customLoggersList);
            this.customLogClass.setText("");
            this.writeSettingsToProperties();
            this.customLoggers.setListData(this.customLoggersList.toArray());
            this.btnRemove.setEnabled(!this.customLoggersList.isEmpty());
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.customLoggersList.remove((String)this.customLoggers.getSelectedValue());
        this.writeSettingsToProperties();
        this.customLoggers.setListData(this.customLoggersList.toArray());
        this.btnRemove.setEnabled(!this.customLoggersList.isEmpty());
    }

    private void writeSettingsToProperties() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.customLoggersList) {
            sb.append(s);
            if (this.customLoggersList.indexOf(s) == this.customLoggersList.size() - 1) continue;
            sb.append(",");
        }
        this.p.put(CUSTOM_LOGGERS, sb.toString());
    }

    private List<String> loadLoggersFromPrefs() {
        String loggers = this.p.get(CUSTOM_LOGGERS, null);
        if (loggers == null || loggers.equals("")) {
            this.p.put(CUSTOM_LOGGERS, "");
            return null;
        }
        this.p.put(CUSTOM_LOGGERS, loggers);
        ArrayList<String> loggersList = new ArrayList<String>();
        String[] tmpArray = loggers.split(",");
        loggersList.addAll(Arrays.asList(tmpArray));
        return loggersList;
    }
}

