/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.converter;

import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

import org.apache.myfaces.buildtools.maven2.plugin.builder.annotation.JSFFaceletTag;

@JSFFaceletTag(
        name = "mcc:convertNumber",
        bodyContent = "empty", 
        converterClass="org.apache.myfaces.commons.converter.TypedNumberConverter")
public class TypedNumberConverterTagHandler extends ConverterBaseTagHandler
{

    private final TagAttribute destType;
    
    public TypedNumberConverterTagHandler(ConverterConfig config)
    {
        super(config);
        this.destType = this.getAttribute("destType");
    }
    
    public void setAttributes(FaceletContext ctx, Object obj)
    {
        super.setAttributes(ctx, obj);
        AbstractTypedNumberConverter c = (AbstractTypedNumberConverter) obj;
        if (this.destType != null)
        {
            if (this.destType.isLiteral())
            {
                try
                {
                    c.setDestType(org.apache.myfaces.commons.util.ClassUtils.classForName(this.destType.getValue()));
                }
                catch (ClassNotFoundException e)
                {
                    throw new TagAttributeException(this.destType,"Cannot find class assigned: "+this.destType.getValue(),e);
                }
            }
            else
            {
                c.setValueExpression("destType", this.destType.getValueExpression(ctx, Object.class));
            }
        }
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type)
    {
        MetaRuleset ruleSet = super.createMetaRuleset(type).ignore("destType");
        
        //Add locale rule
        ruleSet.addRule(_LocaleRule.Instance);
        
        return ruleSet;
    }
}
