/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.util.Arrays;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.util.security.KEM;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyPairGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;

final class SNTRUP761
implements KEM {
    static final SNTRUP761 INSTANCE = new SNTRUP761();

    private SNTRUP761() {
    }

    @Override
    public boolean isSupported() {
        if (SecurityUtils.isFipsMode()) {
            return false;
        }
        try {
            return SNTRUPrimeParameters.sntrup761.getSessionKeySize() == 256;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Client getClient() {
        return new Client();
    }

    @Override
    public Server getServer() {
        return new Server();
    }

    static class Client
    implements KEM.Client {
        private SNTRUPrimeKEMExtractor extractor;
        private SNTRUPrimePublicKeyParameters publicKey;

        Client() {
        }

        @Override
        public void init() {
            SNTRUPrimeKeyPairGenerator gen = new SNTRUPrimeKeyPairGenerator();
            gen.init((KeyGenerationParameters)new SNTRUPrimeKeyGenerationParameters(JceRandom.getGlobalInstance(), SNTRUPrimeParameters.sntrup761));
            AsymmetricCipherKeyPair pair = gen.generateKeyPair();
            this.extractor = new SNTRUPrimeKEMExtractor((SNTRUPrimePrivateKeyParameters)pair.getPrivate());
            this.publicKey = (SNTRUPrimePublicKeyParameters)pair.getPublic();
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey.getEncoded();
        }

        @Override
        public byte[] extractSecret(byte[] encapsulated) {
            if (encapsulated.length != this.extractor.getEncapsulationLength()) {
                throw new IllegalArgumentException("KEM encpsulation has wrong length: " + encapsulated.length);
            }
            return this.extractor.extractSecret(encapsulated);
        }

        @Override
        public int getEncapsulationLength() {
            return this.extractor.getEncapsulationLength();
        }
    }

    static class Server
    implements KEM.Server {
        private SecretWithEncapsulation value;

        Server() {
        }

        @Override
        public int getPublicKeyLength() {
            return SNTRUPrimeParameters.sntrup761.getPublicKeyBytes();
        }

        @Override
        public byte[] init(byte[] publicKey) {
            int pkBytes = this.getPublicKeyLength();
            if (publicKey.length < pkBytes) {
                throw new IllegalArgumentException("KEM public key too short: " + publicKey.length);
            }
            byte[] pk = Arrays.copyOf(publicKey, pkBytes);
            SNTRUPrimeKEMGenerator kemGenerator = new SNTRUPrimeKEMGenerator(JceRandom.getGlobalInstance());
            SNTRUPrimePublicKeyParameters params = new SNTRUPrimePublicKeyParameters(SNTRUPrimeParameters.sntrup761, pk);
            this.value = kemGenerator.generateEncapsulated((AsymmetricKeyParameter)params);
            return Arrays.copyOfRange(publicKey, pkBytes, publicKey.length);
        }

        @Override
        public byte[] getSecret() {
            return this.value.getSecret();
        }

        @Override
        public byte[] getEncapsulation() {
            return this.value.getEncapsulation();
        }
    }
}

