/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.resolver.transform;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.repository.legacy.resolver.transform.AbstractVersionTransformation;

@Named(value="latest")
@Singleton
@Deprecated
public class LatestArtifactTransformation
extends AbstractVersionTransformation {
    @Override
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        if ("LATEST".equals(artifact.getVersion())) {
            try {
                String version = this.resolveVersion(artifact, request);
                if ("LATEST".equals(version)) {
                    throw new ArtifactNotFoundException("Unable to determine the latest version", artifact);
                }
                artifact.setBaseVersion(version);
                artifact.updateVersion(version, request.getLocalRepository());
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, (Throwable)e);
            }
        }
    }

    @Override
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) {
    }

    @Override
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) {
    }

    @Override
    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getLatest();
    }
}

