/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.lang.reflect.Proxy;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Exclusion;

public class ExclusionArtifactFilter
implements ArtifactFilter {
    private final List<Exclusion> exclusions;
    private final List<Predicate<Artifact>> predicates;

    public ExclusionArtifactFilter(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
        this.predicates = exclusions.stream().map(ExclusionArtifactFilter::toPredicate).collect(Collectors.toList());
    }

    public boolean include(Artifact artifact) {
        return this.predicates.stream().noneMatch(p -> p.test(artifact));
    }

    private static Predicate<Artifact> toPredicate(Exclusion exclusion) {
        PathMatcher groupId = FileSystems.getDefault().getPathMatcher("glob:" + exclusion.getGroupId());
        PathMatcher artifactId = FileSystems.getDefault().getPathMatcher("glob:" + exclusion.getArtifactId());
        Predicate<Artifact> predGroupId = a -> groupId.matches(ExclusionArtifactFilter.createPathProxy(a.getGroupId()));
        Predicate<Artifact> predArtifactId = a -> artifactId.matches(ExclusionArtifactFilter.createPathProxy(a.getArtifactId()));
        return predGroupId.and(predArtifactId);
    }

    private static Path createPathProxy(String value) {
        return (Path)Proxy.newProxyInstance(ExclusionArtifactFilter.class.getClassLoader(), new Class[]{Path.class}, (proxy1, method, args) -> {
            if ("toString".equals(method.getName())) {
                return value;
            }
            throw new UnsupportedOperationException();
        });
    }
}

