/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.internal.transformation.PomArtifactTransformer;
import org.apache.maven.internal.transformation.TransformationFailedException;
import org.apache.maven.internal.transformation.impl.TransformedArtifactHandler;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;

class TransformedArtifact
extends DefaultArtifact {
    private static final int SHA1_BUFFER_SIZE = 8192;
    private final PomArtifactTransformer pomArtifactTransformer;
    private final MavenProject project;
    private final Supplier<ModelSource> sourcePathProvider;
    private final Path target;
    private final RepositorySystemSession session;
    private final AtomicReference<String> sourceState;

    TransformedArtifact(PomArtifactTransformer pomArtifactTransformer, MavenProject project, Path target, RepositorySystemSession session, Artifact source, Supplier<ModelSource> sourcePathProvider, String classifier, String extension) {
        super(source.getGroupId(), source.getArtifactId(), source.getVersionRange(), source.getScope(), extension, classifier, (ArtifactHandler)new TransformedArtifactHandler(classifier, extension, source.getArtifactHandler().getPackaging()));
        this.pomArtifactTransformer = pomArtifactTransformer;
        this.project = project;
        this.target = target;
        this.session = session;
        this.sourcePathProvider = sourcePathProvider;
        this.sourceState = new AtomicReference<Object>(null);
    }

    public boolean isResolved() {
        return this.getFile() != null;
    }

    public void setFile(File file) {
        throw new UnsupportedOperationException("transformed artifact file cannot be set");
    }

    public synchronized File getFile() {
        try {
            String state = this.mayUpdate();
            if (state == null) {
                return null;
            }
            return this.target.toFile();
        }
        catch (IOException | XMLStreamException | ModelBuilderException e) {
            throw new TransformationFailedException(e);
        }
    }

    private String mayUpdate() throws IOException, XMLStreamException, ModelBuilderException {
        String result;
        ModelSource src = this.sourcePathProvider.get();
        if (src == null) {
            Files.deleteIfExists(this.target);
            result = null;
        } else if (!Files.exists(src.getPath(), new LinkOption[0])) {
            Files.deleteIfExists(this.target);
            result = "";
        } else {
            String current = (String)ChecksumAlgorithmHelper.calculate((Path)src.getPath(), List.of(new Sha1ChecksumAlgorithmFactory())).get("SHA-1");
            String existing = this.sourceState.get();
            if (!Files.exists(this.target, new LinkOption[0]) || !Objects.equals(current, existing)) {
                this.pomArtifactTransformer.transform(this.project, this.session, src, this.target);
                Files.setLastModifiedTime(this.target, Files.getLastModifiedTime(src.getPath(), new LinkOption[0]));
            }
            result = current;
        }
        this.sourceState.set(result);
        return result;
    }
}

