/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;

@Namespace(value="Converter")
@Plugin(value="FullLocationPatternConverter")
@ConverterKeys(value={"l", "location"})
public final class FullLocationPatternConverter
extends LogEventPatternConverter {
    private static final FullLocationPatternConverter INSTANCE = new FullLocationPatternConverter();

    private FullLocationPatternConverter() {
        super("Full Location", "fullLocation");
    }

    public static FullLocationPatternConverter newInstance(String[] options) {
        return INSTANCE;
    }

    @Override
    public void format(LogEvent event, StringBuilder output) {
        StackTraceElement element = event.getSource();
        if (element != null) {
            output.append(element.toString());
        }
    }

    @Override
    public boolean requiresLocation() {
        return true;
    }
}

