/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.Optional;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public class UrlPath {
    final String[] parts;
    final String path;

    public static UrlPath of(String path) {
        if (path != null && !path.startsWith("/")) {
            throw new IllegalArgumentException("Invalid path specified. Must be null or start with '/' per HttpServletRequest.getPathInfo().");
        }
        return new UrlPath(path);
    }

    UrlPath(String path) {
        this.path = path;
        this.parts = path == null ? new String[]{} : StringUtils.split(path.substring(1), '/');
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = StringUtils.urlDecode(this.parts[i]);
        }
    }

    public String[] getParts() {
        return this.parts;
    }

    public Optional<String> getFileName() {
        if (this.parts.length == 0) {
            return CollectionUtils.empty();
        }
        String p = this.parts[this.parts.length - 1];
        if (p.indexOf(46) == -1) {
            return CollectionUtils.empty();
        }
        return CollectionUtils.optional(p);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isTrailingSlash() {
        return this.path != null && this.path.endsWith("/");
    }

    public String toString() {
        return JsonMap.filteredMap().append("raw", this.path).append("parts", this.parts).asReadableString();
    }
}

