/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.ImageLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;

public class InterWikiLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private static final Logger LOG = LogManager.getLogger(InterWikiLinkNodePostProcessorState.class);
    private final Context wikiContext;
    private final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;
    private final Document document;
    private final boolean m_wysiwygEditorMode;
    private boolean m_useOutlinkImage = true;

    public InterWikiLinkNodePostProcessorState(Context wikiContext, Document document, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
        this.document = document;
        this.m_useOutlinkImage = wikiContext.getBooleanWikiProperty("jspwiki.translatorReader.useOutlinkImage", this.m_useOutlinkImage);
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        String[] refAndPage = link.getUrl().toString().split(":");
        if (!this.m_wysiwygEditorMode) {
            String urlReference = this.wikiContext.getEngine().getInterWikiURL(refAndPage[0]);
            if (urlReference != null) {
                if (this.linkOperations.isImageLink(urlReference = TextUtil.replaceString((String)urlReference, (String)"%s", (String)refAndPage[1]), this.isImageInlining, this.inlineImagePatterns)) {
                    new ImageLinkNodePostProcessorState(this.wikiContext, urlReference, link.hasRef()).process(state, link);
                } else {
                    link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)urlReference));
                }
                if (this.linkOperations.isExternalLink(urlReference)) {
                    NodePostProcessorStateCommonOperations.addOutlinkImage(state, (Node)link, this.wikiContext, this.m_useOutlinkImage);
                }
            } else {
                LOG.debug(refAndPage[0] + " not recognized as InterWiki link [document node: " + this.document + "]");
                Object[] args = new Object[]{refAndPage[0]};
                ResourceBundle rb = Preferences.getBundle((Context)this.wikiContext, (String)"CoreResources");
                String errMsg = MessageFormat.format(rb.getString("markupparser.error.nointerwikiref"), args);
                NodePostProcessorStateCommonOperations.makeError(state, (Node)link, errMsg);
            }
        } else {
            link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)(refAndPage[0] + ":" + refAndPage[1])));
        }
    }
}

