/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.james.mime4j.storage.AbstractStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageOutputStream;

public class TempFileStorageProvider
extends AbstractStorageProvider {
    private static final String DEFAULT_PREFIX = "m4j";
    private final String prefix;
    private final String suffix;
    private final File directory;

    public TempFileStorageProvider() {
        this(DEFAULT_PREFIX, null, null);
    }

    public TempFileStorageProvider(File directory) {
        this(DEFAULT_PREFIX, null, directory);
    }

    public TempFileStorageProvider(String prefix, String suffix, File directory) {
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException("invalid prefix");
        }
        if (directory != null) {
            try {
                FileUtils.forceMkdir((File)directory);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("invalid directory");
            }
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
    }

    @Override
    public StorageOutputStream createStorageOutputStream() throws IOException {
        File file = this.directory == null ? Files.createTempFile(this.prefix, this.suffix, new FileAttribute[0]).toFile() : Files.createTempFile(this.directory.toPath(), this.prefix, this.suffix, new FileAttribute[0]).toFile();
        file.deleteOnExit();
        return new TempFileStorageOutputStream(file);
    }

    private static final class TempFileStorageOutputStream
    extends StorageOutputStream {
        private final File file;
        private OutputStream out;

        public TempFileStorageOutputStream(File file) throws IOException {
            this.file = file;
            this.out = new FileOutputStream(file);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.close();
        }

        @Override
        protected void write0(byte[] buffer, int offset, int length) throws IOException {
            this.out.write(buffer, offset, length);
        }

        @Override
        protected Storage toStorage0() throws IOException {
            return new TempFileStorage(this.file);
        }
    }

    private static final class TempFileStorage
    implements Storage {
        private File file;
        private static final Set<File> filesToDelete = new HashSet<File>();

        public TempFileStorage(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            Set<File> set = filesToDelete;
            synchronized (set) {
                if (this.file != null) {
                    filesToDelete.add(this.file);
                    this.file = null;
                }
                Iterator<File> iterator = filesToDelete.iterator();
                while (iterator.hasNext()) {
                    try {
                        FileUtils.forceDelete((File)iterator.next());
                        iterator.remove();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.file == null) {
                throw new IllegalStateException("storage has been deleted");
            }
            return new BufferedInputStream(new FileInputStream(this.file));
        }
    }
}

