/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server;

import java.security.AccessControlException;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!\u0002\u0012$\u0001\u0015Z\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u000bm\u0002A\u0011\u0001\u001f\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\"1Q\t\u0001Q\u0001\n\tCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u00191\u0007\u0001)A\u0005'\"9q\r\u0001b\u0001\n\u0013\u0011\u0006B\u00025\u0001A\u0003%1\u000bC\u0004j\u0001\t\u0007I\u0011\u0002*\t\r)\u0004\u0001\u0015!\u0003T\u0011\u001dY\u0007A1A\u0005\n1Da!\u001e\u0001!\u0002\u0013i\u0007b\u0002<\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007o\u0002\u0001\u000b\u0011B7\t\u000fa\u0004!\u0019!C\u0005Y\"1\u0011\u0010\u0001Q\u0001\n5DqA\u001f\u0001C\u0002\u0013%A\u000e\u0003\u0004|\u0001\u0001\u0006I!\u001c\u0005\by\u0002\u0011\r\u0011\"\u0003m\u0011\u0019i\b\u0001)A\u0005[\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u0019\t9\u0002\u0001C\u0001\u0003\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011%\ty\u0004AI\u0001\n\u0003\t\t\u0005C\u0004\u0002X\u0001!\t!!\u0017\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005\u0005#!D!dG\u0016\u001c8/T1oC\u001e,'O\u0003\u0002%K\u000511/\u001a:wKJT!AJ\u0014\u0002\t1Lg/\u001f\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xmE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a5\u001b\u0005)\u0013BA\u001b&\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA\u001a:\u0013\tQTE\u0001\u0005MSZL8i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011Qh\u0010\t\u0003}\u0001i\u0011a\t\u0005\u0006m\t\u0001\r\u0001O\u0001\u0007C\u000ed7o\u00148\u0016\u0003\t\u0003\"!L\"\n\u0005\u0011s#a\u0002\"p_2,\u0017M\\\u0001\bC\u000ed7o\u00148!\u000319\u0016\n\u0014#D\u0003J#u,Q\"M+\u0005A\u0005CA%O\u001b\u0005Q%BA&M\u0003\u0011a\u0017M\\4\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u001b]KE\nR\"B%\u0012{\u0016i\u0011'!\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0002'B\u0019A\u000bX0\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-8\u0003\u0019a$o\\8u}%\tq&\u0003\u0002\\]\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\r\u0019V-\u001d\u0006\u00037:\u0002\"\u0001\u00193\u000f\u0005\u0005\u0014\u0007C\u0001,/\u0013\t\u0019g&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001f\u0016T!a\u0019\u0018\u0002\u0017M,\b/\u001a:Vg\u0016\u00148\u000fI\u0001\f[>$\u0017NZ=Vg\u0016\u00148/\u0001\u0007n_\u0012Lg-_+tKJ\u001c\b%A\u0005wS\u0016<Xk]3sg\u0006Qa/[3x+N,'o\u001d\u0011\u0002\u0019\u0005dGn\\<fIV\u001bXM]:\u0016\u00035\u00042A\\:`\u001b\u0005y'B\u00019r\u0003%IW.\\;uC\ndWM\u0003\u0002s]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q|'aA*fi\u0006i\u0011\r\u001c7po\u0016$Wk]3sg\u0002\n\u0001B^5fo\u0006\u001bGn]\u0001\nm&,w/Q2mg\u0002\n!\"\\8eS\u001aL\u0018i\u00197t\u0003-iw\u000eZ5gs\u0006\u001bGn\u001d\u0011\u0002\u0013M,\b/\u001a:BG2\u001c\u0018AC:va\u0016\u0014\u0018i\u00197tA\u0005Y\u0011\r\u001c7po\u0016$\u0017i\u00197t\u00031\tG\u000e\\8xK\u0012\f5\r\\:!\u0003Q\u0019\u0007.Z2l-&,w\u000fU3s[&\u001c8/[8ogR\u0019!)!\u0001\t\r\u0005\rq\u00031\u0001`\u0003\u0011)8/\u001a:\u0002-\rDWmY6N_\u0012Lg-\u001f)fe6L7o]5p]N$2AQA\u0005\u0011\u0019\t\u0019\u0001\u0007a\u0001?\u0006q1\r[3dWN+\b/\u001a:Vg\u0016\u0014Hc\u0001\"\u0002\u0010!1\u00111A\rA\u0002}\u000bQ\"[:Vg\u0016\u0014\u0018\t\u001c7po\u0016$Gc\u0001\"\u0002\u0016!1\u00111\u0001\u000eA\u0002}\u000b\u0011#[:BG\u000e,7o]\"p]R\u0014x\u000e\\(o\u0003I\u0019\u0007.Z2l\u00136\u0004XM]:p]\u0006$\u0018n\u001c8\u0015\r\u0005u\u00111EA\u0014!\u0011i\u0013qD0\n\u0007\u0005\u0005bF\u0001\u0004PaRLwN\u001c\u0005\b\u0003Ka\u0002\u0019AA\u000f\u0003\u0019!\u0018M]4fi\"1\u0011\u0011\u0006\u000fA\u0002}\u000b1B]3rk\u0016\u001cH/V:fe\u0006q\u0001.Y:TkB,'/Q2dKN\u001cH#\u0002\"\u00020\u0005E\u0002BBA\u0013;\u0001\u0007q\f\u0003\u0004\u0002*u\u0001\raX\u0001\u0010Q\u0006\u001cXj\u001c3jMf\f5mY3tgR9!)a\u000e\u0002:\u0005m\u0002BBA\u0013=\u0001\u0007q\f\u0003\u0004\u0002*y\u0001\ra\u0018\u0005\t\u0003{q\u0002\u0013!a\u0001?\u0006I\u0001O]8ysV\u001bXM]\u0001\u001aQ\u0006\u001cXj\u001c3jMf\f5mY3tg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002D)\u001aq,!\u0012,\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0015/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\nYEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002[1t-&,w/Q2dKN\u001cHc\u0002\"\u0002\\\u0005u\u0013q\f\u0005\u0007\u0003K\u0001\u0003\u0019A0\t\r\u0005%\u0002\u00051\u0001`\u0011!\ti\u0004\tI\u0001\u0002\u0004y\u0016a\u00065bgZKWm^!dG\u0016\u001c8\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class AccessManager
implements Logging {
    private final LivyConf conf;
    private final boolean aclsOn;
    private final String WILDCARD_ACL;
    private final Seq<String> superUsers;
    private final Seq<String> modifyUsers;
    private final Seq<String> viewUsers;
    private final Set<String> allowedUsers;
    private final Set<String> viewAcls;
    private final Set<String> modifyAcls;
    private final Set<String> superAcls;
    private final Set<String> allowedAcls;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AccessManager accessManager = this;
        synchronized (accessManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private boolean aclsOn() {
        return this.aclsOn;
    }

    private String WILDCARD_ACL() {
        return this.WILDCARD_ACL;
    }

    private Seq<String> superUsers() {
        return this.superUsers;
    }

    private Seq<String> modifyUsers() {
        return this.modifyUsers;
    }

    private Seq<String> viewUsers() {
        return this.viewUsers;
    }

    private Set<String> allowedUsers() {
        return this.allowedUsers;
    }

    private Set<String> viewAcls() {
        return this.viewAcls;
    }

    private Set<String> modifyAcls() {
        return this.modifyAcls;
    }

    private Set<String> superAcls() {
        return this.superAcls;
    }

    private Set<String> allowedAcls() {
        return this.allowedAcls;
    }

    public boolean checkViewPermissions(String user) {
        this.debug((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("user=").append(user).append(" aclsOn=").append(this.aclsOn()).append(" viewAcls=").append(this.viewAcls().mkString(", ")).toString());
        return !this.aclsOn() || user == null || this.viewAcls().contains((Object)this.WILDCARD_ACL()) || this.viewAcls().contains((Object)user);
    }

    public boolean checkModifyPermissions(String user) {
        this.debug((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(25).append("user=").append(user).append(" aclsOn=").append(this.aclsOn()).append(" modifyAcls=").append(this.modifyAcls().mkString(", ")).toString());
        return !this.aclsOn() || user == null || this.modifyAcls().contains((Object)this.WILDCARD_ACL()) || this.modifyAcls().contains((Object)user);
    }

    public boolean checkSuperUser(String user) {
        this.debug((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append("user=").append(user).append(" aclsOn=").append(this.aclsOn()).append(" superAcls=").append(this.superAcls().mkString(", ")).toString());
        return user == null || this.superUsers().contains((Object)this.WILDCARD_ACL()) || this.superUsers().contains((Object)user);
    }

    public boolean isUserAllowed(String user) {
        this.debug((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(27).append("user=").append(user).append(" aclsOn=").append(this.aclsOn()).append(", allowedAcls=").append(this.allowedAcls().mkString(", ")).toString());
        return !this.aclsOn() || user == null || this.allowedAcls().contains((Object)this.WILDCARD_ACL()) || this.allowedAcls().contains((Object)user);
    }

    public boolean isAccessControlOn() {
        return this.aclsOn();
    }

    public Option<String> checkImpersonation(Option<String> target, String requestUser) {
        if (this.conf.getBoolean(LivyConf$.MODULE$.IMPERSONATION_ENABLED())) {
            if (!target.forall((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.hasSuperAccess(x$1, requestUser)))) {
                throw new AccessControlException(new StringBuilder(38).append("User '").append(requestUser).append("' not allowed to impersonate '").append(target).append("'.").toString());
            }
            return target.orElse((Function0 & java.io.Serializable & Serializable)() -> Option$.MODULE$.apply((Object)requestUser));
        }
        return None$.MODULE$;
    }

    public boolean hasSuperAccess(String target, String requestUser) {
        String string = requestUser;
        String string2 = target;
        return !(string == null ? string2 != null : !string.equals(string2)) || this.checkSuperUser(requestUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasModifyAccess(String target, String requestUser, String proxyUser) {
        String string = requestUser;
        String string2 = target;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = proxyUser;
        String string4 = requestUser;
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!this.checkModifyPermissions(requestUser)) return false;
        return true;
    }

    public String hasModifyAccess$default$3() {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasViewAccess(String target, String requestUser, String proxyUser) {
        String string = requestUser;
        String string2 = target;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = proxyUser;
        String string4 = requestUser;
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!this.checkViewPermissions(requestUser)) return false;
        return true;
    }

    public String hasViewAccess$default$3() {
        return "";
    }

    public AccessManager(LivyConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.aclsOn = conf.getBoolean(LivyConf$.MODULE$.ACCESS_CONTROL_ENABLED());
        this.WILDCARD_ACL = "*";
        this.superUsers = conf.configToSeq(LivyConf$.MODULE$.SUPERUSERS());
        this.modifyUsers = conf.configToSeq(LivyConf$.MODULE$.ACCESS_CONTROL_MODIFY_USERS());
        this.viewUsers = conf.configToSeq(LivyConf$.MODULE$.ACCESS_CONTROL_VIEW_USERS());
        this.allowedUsers = conf.configToSeq(LivyConf$.MODULE$.ACCESS_CONTROL_ALLOWED_USERS()).toSet();
        this.viewAcls = ((TraversableOnce)((TraversableLike)this.superUsers().$plus$plus(this.modifyUsers(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.viewUsers(), Seq$.MODULE$.canBuildFrom())).toSet();
        this.modifyAcls = ((TraversableOnce)this.superUsers().$plus$plus(this.modifyUsers(), Seq$.MODULE$.canBuildFrom())).toSet();
        this.superAcls = this.superUsers().toSet();
        this.allowedAcls = ((TraversableOnce)((TraversableLike)((TraversableLike)this.superUsers().$plus$plus(this.modifyUsers(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.viewUsers(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.allowedUsers(), Seq$.MODULE$.canBuildFrom())).toSet();
        this.info((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(138).append("AccessControlManager acls ").append((Object)(this.aclsOn() ? "enabled" : "disabled")).append(";").append("users with view permission: ").append(this.viewUsers().mkString(", ")).append(";").append("users with modify permission: ").append(this.modifyUsers().mkString(", ")).append(";").append("users with super permission: ").append(this.superUsers().mkString(", ")).append(";").append("other allowed users: ").append(this.allowedUsers().mkString(", ")).toString());
    }
}

