/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import java.util.Objects;

public class JobSpecFluentImpl<A extends JobSpecFluent<A>>
extends BaseFluent<A>
implements JobSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private Integer backoffLimit;
    private String completionMode;
    private Integer completions;
    private Boolean manualSelector;
    private Integer parallelism;
    private LabelSelectorBuilder selector;
    private Boolean suspend;
    private PodTemplateSpecBuilder template;
    private Integer ttlSecondsAfterFinished;

    public JobSpecFluentImpl() {
    }

    public JobSpecFluentImpl(JobSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withBackoffLimit(instance.getBackoffLimit());
        this.withCompletionMode(instance.getCompletionMode());
        this.withCompletions(instance.getCompletions());
        this.withManualSelector(instance.getManualSelector());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withSuspend(instance.getSuspend());
        this.withTemplate(instance.getTemplate());
        this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    @Override
    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)this;
    }

    @Override
    public Boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    @Override
    public String getCompletionMode() {
        return this.completionMode;
    }

    @Override
    public A withCompletionMode(String completionMode) {
        this.completionMode = completionMode;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    @Override
    @Deprecated
    public A withNewCompletionMode(String arg0) {
        return this.withCompletionMode(new String(arg0));
    }

    @Override
    public Integer getCompletions() {
        return this.completions;
    }

    @Override
    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)this;
    }

    @Override
    public Boolean hasCompletions() {
        return this.completions != null;
    }

    @Override
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    @Override
    public A withManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return (A)this;
    }

    @Override
    public Boolean hasManualSelector() {
        return this.manualSelector != null;
    }

    @Override
    public Integer getParallelism() {
        return this.parallelism;
    }

    @Override
    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)this;
    }

    @Override
    public Boolean hasParallelism() {
        return this.parallelism != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public JobSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public JobSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public JobSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public JobSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public JobSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public JobSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public JobSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public JobSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    @Override
    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)this;
    }

    @Override
    public Boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSpecFluentImpl that = (JobSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.backoffLimit != null ? !this.backoffLimit.equals(that.backoffLimit) : that.backoffLimit != null) {
            return false;
        }
        if (this.completionMode != null ? !this.completionMode.equals(that.completionMode) : that.completionMode != null) {
            return false;
        }
        if (this.completions != null ? !this.completions.equals(that.completions) : that.completions != null) {
            return false;
        }
        if (this.manualSelector != null ? !this.manualSelector.equals(that.manualSelector) : that.manualSelector != null) {
            return false;
        }
        if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals((Object)that.selector) : that.selector != null) {
            return false;
        }
        if (this.suspend != null ? !this.suspend.equals(that.suspend) : that.suspend != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals((Object)that.template) : that.template != null) {
            return false;
        }
        return !(this.ttlSecondsAfterFinished != null ? !this.ttlSecondsAfterFinished.equals(that.ttlSecondsAfterFinished) : that.ttlSecondsAfterFinished != null);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.completionMode, this.completions, this.manualSelector, this.parallelism, this.selector, this.suspend, this.template, this.ttlSecondsAfterFinished, super.hashCode());
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<JobSpecFluent.TemplateNested<N>>
    implements JobSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this);
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<JobSpecFluent.SelectorNested<N>>
    implements JobSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)JobSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

