/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.bifromq.type.RouteMatcher;

public class TopicUtil {
    private static final String PREFIX_UNORDERED_SHARE = "$share/";
    private static final String PREFIX_ORDERED_SHARE = "$oshare/";

    public static boolean isValidTopic(String topic, int maxLevelLength, int maxLevel, int maxLength) {
        assert (maxLength <= 65535 && maxLevelLength <= maxLength);
        if (topic.isEmpty() || topic.length() > maxLength) {
            return false;
        }
        if (topic.startsWith(PREFIX_ORDERED_SHARE) || topic.startsWith(PREFIX_UNORDERED_SHARE)) {
            return false;
        }
        int topicLevelLength = 0;
        int level = 1;
        for (int i = 0; i < topic.length(); ++i) {
            if (topic.charAt(i) == '/') {
                if (++level > maxLevel) {
                    return false;
                }
                if (topicLevelLength > maxLevelLength) {
                    return false;
                }
                topicLevelLength = 0;
                continue;
            }
            char c = topic.charAt(i);
            if (c == '\u0000' || c == '+' || c == '#') {
                return false;
            }
            ++topicLevelLength;
        }
        return topicLevelLength <= maxLevelLength;
    }

    public static boolean isValidTopicFilter(String topicFilter, int maxLevelLength, int maxLevel, int maxLength) {
        if (topicFilter.startsWith(PREFIX_UNORDERED_SHARE)) {
            maxLength += PREFIX_UNORDERED_SHARE.length();
        }
        if (topicFilter.startsWith(PREFIX_ORDERED_SHARE)) {
            maxLength += PREFIX_ORDERED_SHARE.length();
        }
        assert (maxLength <= 65535 && maxLevelLength <= maxLength);
        if (topicFilter.isEmpty() || topicFilter.length() > maxLength) {
            return false;
        }
        int i = 0;
        int topicLevelLength = 0;
        if (topicFilter.startsWith(PREFIX_ORDERED_SHARE) || topicFilter.startsWith(PREFIX_UNORDERED_SHARE)) {
            char c;
            for (i = topicFilter.indexOf(47) + 1; i < topicFilter.length() && (c = topicFilter.charAt(i)) != '/'; ++i) {
                if (c == '#' || c == '+' || c == '\u0000') {
                    return false;
                }
                ++topicLevelLength;
            }
            if (topicLevelLength == 0) {
                return false;
            }
            if (i == topicFilter.length()) {
                return false;
            }
            topicLevelLength = 0;
            ++i;
        }
        int startIdx = i;
        int level = 1;
        while (i < topicFilter.length()) {
            if (topicFilter.charAt(i) == '/') {
                if (++level > maxLevel) {
                    return false;
                }
                if (topicLevelLength > maxLevelLength) {
                    return false;
                }
                topicLevelLength = 0;
            } else {
                char c = topicFilter.charAt(i);
                if (c == '\u0000') {
                    return false;
                }
                if (c == '#') {
                    if (i != topicFilter.length() - 1) {
                        return false;
                    }
                    if (i != startIdx && topicFilter.charAt(i - 1) != '/') {
                        return false;
                    }
                }
                if (c == '+' && (i == startIdx ? i != topicFilter.length() - 1 && topicFilter.charAt(i + 1) != '/' : (i == topicFilter.length() - 1 ? topicFilter.charAt(i - 1) != '/' : topicFilter.charAt(i - 1) != '/' || topicFilter.charAt(i + 1) != '/'))) {
                    return false;
                }
                ++topicLevelLength;
            }
            ++i;
        }
        if (level > maxLevel) {
            return false;
        }
        return topicLevelLength <= maxLevelLength;
    }

    public static boolean isWildcardTopicFilter(String topicFilter) {
        return topicFilter.indexOf(43) >= 0 || TopicUtil.isMultiWildcardTopicFilter(topicFilter);
    }

    public static boolean isMultiWildcardTopicFilter(String topicFilter) {
        return topicFilter.endsWith("#");
    }

    public static boolean isSharedSubscription(String topicFilter) {
        return TopicUtil.isOrderedShared(topicFilter) || TopicUtil.isUnorderedShared(topicFilter);
    }

    public static boolean isNormalTopicFilter(String topicFilter) {
        return !TopicUtil.isSharedSubscription(topicFilter);
    }

    public static boolean isUnorderedShared(String topicFilter) {
        return topicFilter.startsWith(PREFIX_UNORDERED_SHARE);
    }

    public static boolean isOrderedShared(String topicFilter) {
        return topicFilter.startsWith(PREFIX_ORDERED_SHARE);
    }

    public static String escape(String topicFilter) {
        assert (!topicFilter.contains("\u0000"));
        return topicFilter.replace("/", "\u0000");
    }

    public static String unescape(String topicFilter) {
        return topicFilter.replace("\u0000", "/");
    }

    public static List<String> parse(String tenantId, String topic, boolean isEscaped) {
        ArrayList<String> topicLevels = new ArrayList<String>();
        topicLevels.add(tenantId);
        return TopicUtil.parse(topic, isEscaped, topicLevels);
    }

    public static List<String> parse(String topic, boolean isEscaped) {
        return TopicUtil.parse(topic, isEscaped, new ArrayList<String>());
    }

    private static List<String> parse(String topic, boolean isEscaped, List<String> topicLevels) {
        char splitter = isEscaped ? (char)'\u0000' : '/';
        StringBuilder tl = new StringBuilder();
        for (int i = 0; i < topic.length(); ++i) {
            if (topic.charAt(i) == splitter) {
                topicLevels.add(tl.toString());
                tl.delete(0, tl.length());
                continue;
            }
            tl.append(topic.charAt(i));
        }
        topicLevels.add(tl.toString());
        return topicLevels;
    }

    public static String fastJoin(CharSequence delimiter, Iterable<? extends CharSequence> strings) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends CharSequence> itr = strings.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static <T> String fastJoin(CharSequence delimiter, Iterable<T> items, Function<T, ? extends CharSequence> toCharSequence) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> itr = items.iterator();
        while (itr.hasNext()) {
            sb.append(toCharSequence.apply(itr.next()));
            if (!itr.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static RouteMatcher from(String topicFilter) {
        if (TopicUtil.isNormalTopicFilter(topicFilter)) {
            return RouteMatcher.newBuilder().setType(RouteMatcher.Type.Normal).addAllFilterLevel(TopicUtil.parse(topicFilter, false)).setMqttTopicFilter(topicFilter).build();
        }
        String sharePrefix = topicFilter.startsWith("$share") ? "$share" : "$oshare";
        boolean ordered = !topicFilter.startsWith("$share");
        String rest = topicFilter.substring((sharePrefix + "/").length());
        int firstTopicSeparatorIndex = rest.indexOf(47);
        String shareGroup = rest.substring(0, firstTopicSeparatorIndex);
        return RouteMatcher.newBuilder().setType(ordered ? RouteMatcher.Type.OrderedShare : RouteMatcher.Type.UnorderedShare).addAllFilterLevel(TopicUtil.parse(rest.substring(firstTopicSeparatorIndex + 1), false)).setGroup(shareGroup).setMqttTopicFilter(topicFilter).build();
    }
}

