/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.proto.Boundary;

class InMemKVSpaceWriterHelper {
    private final Map<String, InMemKVSpaceEpoch> kvSpaceEpochMap;
    private final Map<String, WriteBatch> batchMap;
    private final Map<String, Consumer<Boolean>> afterWriteCallbacks = new HashMap<String, Consumer<Boolean>>();
    private final Map<String, Consumer<WriteImpact>> afterImpactCallbacks = new HashMap<String, Consumer<WriteImpact>>();
    private final Map<String, Boolean> metadataChanges = new HashMap<String, Boolean>();
    private final Set<ISyncContext.IMutator> mutators = new HashSet<ISyncContext.IMutator>();

    InMemKVSpaceWriterHelper() {
        this.kvSpaceEpochMap = new HashMap<String, InMemKVSpaceEpoch>();
        this.batchMap = new HashMap<String, WriteBatch>();
    }

    void addMutators(String id, InMemKVSpaceEpoch epoch, ISyncContext.IMutator mutator) {
        this.kvSpaceEpochMap.put(id, epoch);
        this.mutators.add(mutator);
    }

    void addAfterWriteCallback(String rangeId, Consumer<Boolean> afterWrite) {
        this.afterWriteCallbacks.put(rangeId, afterWrite);
        this.metadataChanges.put(rangeId, false);
    }

    void addAfterImpactCallback(String rangeId, Consumer<WriteImpact> afterImpact) {
        this.afterImpactCallbacks.put(rangeId, afterImpact);
    }

    void metadata(String rangeId, ByteString metaKey, ByteString metaValue) {
        this.batchMap.computeIfAbsent(rangeId, k -> new WriteBatch(rangeId)).metadata(metaKey, metaValue);
        this.metadataChanges.computeIfPresent(rangeId, (k, v) -> true);
    }

    void insert(String rangeId, ByteString key, ByteString value) {
        this.batchMap.computeIfAbsent(rangeId, k -> new WriteBatch(rangeId)).insert(key, value);
    }

    void put(String rangeId, ByteString key, ByteString value) {
        this.batchMap.computeIfAbsent(rangeId, k -> new WriteBatch(rangeId)).put(key, value);
    }

    void delete(String rangeId, ByteString key) {
        this.batchMap.computeIfAbsent(rangeId, k -> new WriteBatch(rangeId)).delete(key);
    }

    void clear(String rangeId, Boundary boundary) {
        this.batchMap.computeIfAbsent(rangeId, k -> new WriteBatch(rangeId)).deleteRange(boundary);
    }

    void done() {
        ISyncContext.IMutation doneFn = () -> {
            HashMap<String, WriteImpact> impacts = new HashMap<String, WriteImpact>();
            this.batchMap.values().forEach(batch -> {
                WriteImpact impact = batch.endAndCollectImpact();
                if (impact != null) {
                    impacts.put(batch.rangeId, impact);
                }
            });
            impacts.forEach((id, imp) -> {
                Consumer<WriteImpact> cb = this.afterImpactCallbacks.get(id);
                if (cb != null) {
                    cb.accept((WriteImpact)imp);
                }
            });
            return false;
        };
        AtomicReference<ISyncContext.IMutation> finalRun = new AtomicReference<ISyncContext.IMutation>();
        for (ISyncContext.IMutator mutator : this.mutators) {
            if (finalRun.get() == null) {
                finalRun.set(() -> mutator.run(doneFn));
                continue;
            }
            ISyncContext.IMutation innerRun = (ISyncContext.IMutation)finalRun.get();
            finalRun.set(() -> mutator.run(innerRun));
        }
        ((ISyncContext.IMutation)finalRun.get()).mutate();
        for (String rangeId : this.afterWriteCallbacks.keySet()) {
            this.afterWriteCallbacks.get(rangeId).accept(this.metadataChanges.get(rangeId));
        }
    }

    void abort() {
        this.batchMap.clear();
    }

    int count() {
        return this.batchMap.values().stream().map(WriteBatch::count).reduce(0, Integer::sum);
    }

    protected class WriteBatch {
        private final String rangeId;
        Map<ByteString, ByteString> metadata = new HashMap<ByteString, ByteString>();
        List<KVAction> actions = new ArrayList<KVAction>();

        protected WriteBatch(String spaceId) {
            this.rangeId = spaceId;
        }

        public void metadata(ByteString key, ByteString value) {
            this.metadata.put(key, value);
        }

        public int count() {
            return this.actions.size();
        }

        public void insert(ByteString key, ByteString value) {
            this.actions.add(new Put(key, value));
        }

        public void put(ByteString key, ByteString value) {
            this.actions.add(new Put(key, value));
        }

        public void delete(ByteString key) {
            this.actions.add(new Delete(key));
        }

        public void deleteRange(Boundary boundary) {
            this.actions.add(new DeleteRange(boundary));
        }

        public WriteImpact endAndCollectImpact() {
            ArrayList<ByteString> putOrDeleteKeys = new ArrayList<ByteString>();
            ArrayList<Boundary> deleteRanges = new ArrayList<Boundary>();
            HashMap<ByteString, Integer> pointDeltaBytes = new HashMap<ByteString, Integer>();
            InMemKVSpaceEpoch epoch = InMemKVSpaceWriterHelper.this.kvSpaceEpochMap.get(this.rangeId);
            this.metadata.forEach(epoch::setMetadata);
            for (KVAction action : this.actions) {
                switch (action.type()) {
                    case Put: {
                        Put put = (Put)action;
                        ByteString old = (ByteString)epoch.dataMap().get(put.key);
                        int oldBytes = old == null ? 0 : put.key.size() + old.size();
                        int newBytes = put.key.size() + put.value.size();
                        int delta = newBytes - oldBytes;
                        if (delta != 0) {
                            pointDeltaBytes.merge(put.key, delta, Integer::sum);
                        }
                        epoch.putData(put.key, put.value);
                        putOrDeleteKeys.add(put.key);
                        break;
                    }
                    case Delete: {
                        Delete delete = (Delete)action;
                        ByteString old = (ByteString)epoch.dataMap().get(delete.key);
                        if (old != null) {
                            int delta = -(delete.key.size() + old.size());
                            pointDeltaBytes.merge(delete.key, delta, Integer::sum);
                            epoch.removeData(delete.key);
                        }
                        putOrDeleteKeys.add(delete.key);
                        break;
                    }
                    case DeleteRange: {
                        DeleteRange deleteRange = (DeleteRange)action;
                        Boundary boundary = deleteRange.boundary;
                        NavigableSet<ByteString> inRangeKeys = !boundary.hasStartKey() && !boundary.hasEndKey() ? epoch.dataMap().navigableKeySet() : (!boundary.hasStartKey() ? epoch.dataMap().headMap(boundary.getEndKey(), false).navigableKeySet() : (!boundary.hasEndKey() ? epoch.dataMap().tailMap(boundary.getStartKey(), true).navigableKeySet() : epoch.dataMap().subMap(boundary.getStartKey(), true, boundary.getEndKey(), false).navigableKeySet()));
                        for (ByteString k : inRangeKeys) {
                            ByteString v = (ByteString)epoch.dataMap().get(k);
                            if (v == null) continue;
                            int delta = -(k.size() + v.size());
                            pointDeltaBytes.merge(k, delta, Integer::sum);
                        }
                        inRangeKeys.forEach(epoch::removeData);
                        deleteRanges.add(boundary);
                        break;
                    }
                }
            }
            return new WriteImpact(putOrDeleteKeys, deleteRanges, pointDeltaBytes);
        }

        public void abort() {
        }

        record Put(ByteString key, ByteString value) implements KVAction
        {
            @Override
            public KVAction.Type type() {
                return KVAction.Type.Put;
            }
        }

        record Delete(ByteString key) implements KVAction
        {
            @Override
            public KVAction.Type type() {
                return KVAction.Type.Delete;
            }
        }

        record DeleteRange(Boundary boundary) implements KVAction
        {
            @Override
            public KVAction.Type type() {
                return KVAction.Type.DeleteRange;
            }
        }
    }

    public record WriteImpact(List<ByteString> pointKeys, List<Boundary> deleteRanges, Map<ByteString, Integer> pointDeltaBytes) {
    }

    protected static interface KVAction {
        public Type type();

        public static enum Type {
            Put,
            Delete,
            DeleteRange;

        }
    }
}

