/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.store.option.KVRangeOptions;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.SettingProviderManager;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.retain.server.IRetainServer;
import org.apache.bifromq.retain.store.IRetainStore;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.retain.RetainServerConfig;
import org.apache.bifromq.starter.config.model.retain.RetainStoreConfig;
import org.apache.bifromq.starter.module.ServiceInjector;

public class RetainServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<IRetainServer>>(){}).toProvider(RetainServerProvider.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<Optional<IRetainStore>>(){}).toProvider(RetainStoreProvider.class).in(Singleton.class);
    }

    private static class RetainServerProvider
    implements Provider<Optional<IRetainServer>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private RetainServerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IRetainServer> get() {
            RetainServerConfig serverConfig = this.config.getRetainServiceConfig().getServer();
            if (!serverConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(IRetainServer.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).distClient(this.injector.getInstance(IDistClient.class)).retainStoreClient((IBaseKVStoreClient)this.injector.getInstance(Key.get(IBaseKVStoreClient.class, (Annotation)Names.named((String)"retainStoreClient")))).settingProvider((ISettingProvider)this.injector.getInstance(SettingProviderManager.class)).subBrokerManager(this.injector.getInstance(ISubBrokerManager.class)).attributes(serverConfig.getAttributes()).defaultGroupTags(serverConfig.getDefaultGroups()).build());
        }
    }

    private static class RetainStoreProvider
    implements Provider<Optional<IRetainStore>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private RetainStoreProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IRetainStore> get() {
            RetainStoreConfig storeConfig = this.config.getRetainServiceConfig().getStore();
            if (!storeConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(IRetainStore.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).agentHost(this.injector.getInstance(IAgentHost.class)).metaService(this.injector.getInstance(IBaseKVMetaService.class)).retainStoreClient((IBaseKVStoreClient)this.injector.getInstance(Key.get(IBaseKVStoreClient.class, (Annotation)Names.named((String)"retainStoreClient")))).workerThreads(storeConfig.getWorkerThreads()).tickerThreads(storeConfig.getTickerThreads()).bgTaskExecutor((ScheduledExecutorService)this.injector.getInstance(Key.get(ScheduledExecutorService.class, (Annotation)Names.named((String)"bgTaskScheduler")))).bootstrapDelay(Duration.ofMillis(storeConfig.getBalanceConfig().getBootstrapDelayInMS())).zombieProbeDelay(Duration.ofMillis(storeConfig.getBalanceConfig().getZombieProbeDelayInMS())).balancerRetryDelay(Duration.ofMillis(storeConfig.getBalanceConfig().getRetryDelayInMS())).balancerFactoryConfig(storeConfig.getBalanceConfig().getBalancers()).gcInterval(Duration.ofSeconds(storeConfig.getGcIntervalSeconds())).storeOptions(new KVRangeStoreOptions().setKvRangeOptions(new KVRangeOptions().setMaxWALFatchBatchSize(storeConfig.getMaxWALFetchSize()).setCompactWALThreshold(storeConfig.getCompactWALThreshold())).setSplitHinterFactoryConfig(storeConfig.getSplitHinterConfig().getHinters()).setDataEngineType(storeConfig.getDataEngineConfig().getType()).setDataEngineConf(storeConfig.getDataEngineConfig().toStruct()).setWalEngineType(storeConfig.getWalEngineConfig().getType()).setWalEngineConf(storeConfig.getWalEngineConfig().toStruct())).attributes(storeConfig.getAttributes()).build());
        }
    }
}

