/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.util.GridClientConsistentHash;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClientPartitionAffinity
implements GridClientDataAffinity,
GridClientTopologyListener {
    public static final int DFLT_PARTITION_CNT = 10000;
    private final GridClientConsistentHash<NodeInfo> nodeHash;
    private HashIdResolver hashIdRslvr = new HashIdResolver(){

        @Override
        public Object getHashId(GridClientNode node) {
            return node.consistentId();
        }
    };
    private int parts = 10000;
    private final ConcurrentMap<UUID, NodeInfo> addedNodes = new ConcurrentHashMap<UUID, NodeInfo>();
    private GridClientPredicate<UUID> backupFilter;
    private final GridClientPredicate<NodeInfo> backupIdFilter = new GridClientPredicate<NodeInfo>(){

        @Override
        public boolean apply(NodeInfo info) {
            return GridClientPartitionAffinity.this.backupFilter == null || GridClientPartitionAffinity.this.backupFilter.apply(info.nodeId());
        }
    };
    private final GridClientPredicate<NodeInfo> primaryIdFilter = new GridClientPredicate<NodeInfo>(){

        @Override
        public boolean apply(NodeInfo info) {
            return GridClientPartitionAffinity.this.backupFilter == null || !GridClientPartitionAffinity.this.backupFilter.apply(info.nodeId());
        }
    };

    public GridClientPartitionAffinity() {
        this(null, null);
    }

    public GridClientPartitionAffinity(Integer parts, GridClientPredicate<UUID> backupFilter) {
        this.parts = parts == null ? 10000 : parts;
        this.backupFilter = backupFilter;
        this.nodeHash = new GridClientConsistentHash();
    }

    public int getPartitions() {
        return this.parts;
    }

    public GridClientPartitionAffinity setPartitions(int parts) {
        this.parts = parts;
        return this;
    }

    public HashIdResolver getHashIdResolver() {
        return this.hashIdRslvr;
    }

    public GridClientPartitionAffinity setHashIdResolver(HashIdResolver hashIdRslvr) {
        this.hashIdRslvr = hashIdRslvr;
        return this;
    }

    public GridClientPredicate<UUID> getBackupFilter() {
        return this.backupFilter;
    }

    public GridClientPartitionAffinity setBackupFilter(GridClientPredicate<UUID> backupFilter) {
        this.backupFilter = backupFilter;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GridClientNode node(Object key, Collection<? extends GridClientNode> nodes) {
        void var5_9;
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return GridClientUtils.first(nodes);
        }
        HashMap<NodeInfo, GridClientNode> lookup = U.newHashMap(nodes.size());
        for (GridClientNode gridClientNode : nodes) {
            lookup.put(this.resolveNodeInfo(gridClientNode), gridClientNode);
        }
        Set nodeInfos = lookup.keySet();
        int part = this.partition(key);
        if (this.backupFilter == null) {
            NodeInfo nodeInfo = this.nodeHash.node((Object)part, nodeInfos);
        } else {
            NodeInfo nodeInfo = this.nodeHash.node((Object)part, this.primaryIdFilter, GridClientUtils.contains(nodeInfos));
            if (nodeInfo == null) {
                NodeInfo nodeInfo2 = this.nodeHash.node((Object)part, this.backupIdFilter, GridClientUtils.contains(nodeInfos));
            }
        }
        return (GridClientNode)lookup.get(var5_9);
    }

    private int partition(Object key) {
        return Math.abs(key.hashCode() % this.getPartitions());
    }

    @Override
    public void onNodeAdded(GridClientNode node) {
    }

    @Override
    public void onNodeRemoved(GridClientNode node) {
        UUID nodeId = node.nodeId();
        NodeInfo nodeInfo = (NodeInfo)this.addedNodes.remove(nodeId);
        if (nodeInfo == null) {
            return;
        }
        this.nodeHash.removeNode(nodeInfo);
    }

    private NodeInfo resolveNodeInfo(GridClientNode n) {
        UUID nodeId = n.nodeId();
        NodeInfo nodeInfo = (NodeInfo)this.addedNodes.get(nodeId);
        if (nodeInfo != null) {
            return nodeInfo;
        }
        nodeInfo = new NodeInfo(nodeId, this.hashIdRslvr == null ? nodeId : this.hashIdRslvr.getHashId(n));
        this.addedNodes.put(nodeId, nodeInfo);
        this.nodeHash.addNode(nodeInfo, 1);
        return nodeInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [nodeHash=").append(this.nodeHash).append(", hashIdRslvr=").append(this.hashIdRslvr).append(", parts=").append(this.parts).append(", addedNodes=").append(this.addedNodes).append(", backupFilter=").append(this.backupFilter).append("]");
        return sb.toString();
    }

    private static final class NodeInfo
    implements Comparable<NodeInfo> {
        private final UUID nodeId;
        private final Object hashId;

        private NodeInfo(UUID nodeId, Object hashId) {
            assert (nodeId != null);
            assert (hashId != null);
            this.hashId = hashId;
            this.nodeId = nodeId;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public Object hashId() {
            return this.hashId;
        }

        public int hashCode() {
            return this.hashId.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeInfo)) {
                return false;
            }
            NodeInfo that = (NodeInfo)obj;
            return that.nodeId.equals(this.nodeId) && that.hashCode() == this.hashCode();
        }

        @Override
        public int compareTo(NodeInfo o) {
            int diff = this.nodeId.compareTo(o.nodeId);
            if (diff == 0) {
                diff = Integer.compare(this.hashCode(), o.hashCode());
            }
            return diff;
        }

        public String toString() {
            return NodeInfo.class.getSimpleName() + " [nodeId=" + this.nodeId + ", hashId=" + this.hashId + "]";
        }
    }

    public static interface HashIdResolver {
        public Object getHashId(GridClientNode var1);
    }
}

