/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentFileManager;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite3.raft.jraft.option.LogStorageOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;

class SegstoreLogStorage
implements LogStorage {
    private final long groupId;
    private final SegmentFileManager segmentFileManager;
    private volatile LogEntryEncoder logEntryEncoder;

    SegstoreLogStorage(long groupId, SegmentFileManager segmentFileManager) {
        if (groupId <= 0L) {
            throw new IllegalArgumentException("groupId must be greater than 0: " + groupId);
        }
        this.groupId = groupId;
        this.segmentFileManager = segmentFileManager;
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
        return true;
    }

    @Override
    public boolean appendEntry(LogEntry entry) {
        try {
            this.segmentFileManager.appendEntry(this.groupId, entry, this.logEntryEncoder);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
        return true;
    }

    @Override
    public int appendEntries(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            this.appendEntry(entry);
        }
        return entries.size();
    }

    @Override
    public long getFirstLogIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastLogIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogEntry getEntry(long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTerm(long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean reset(long nextLogIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
    }
}

