/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.client.ClientChannel;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.sql.ClientPartitionAwarenessMetadata;
import org.apache.ignite3.internal.client.sql.ClientResultSetMetadata;
import org.apache.ignite3.internal.client.sql.ClientSqlRow;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.CursorClosedException;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.NoRowSetExpectedException;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

class ClientAsyncResultSet<T>
implements AsyncResultSet<T> {
    private final ClientChannel ch;
    private final Long resourceId;
    private final boolean hasRowSet;
    private final boolean wasApplied;
    private final long affectedRows;
    @Nullable
    private final ResultSetMetadata metadata;
    @Nullable
    private final ClientPartitionAwarenessMetadata partitionAwarenessMetadata;
    @Nullable
    private final Marshaller marshaller;
    @Nullable
    private final Mapper<T> mapper;
    private volatile List<T> rows;
    private volatile boolean hasMorePages;
    private volatile boolean closed;

    ClientAsyncResultSet(ClientChannel ch, MarshallersProvider marshallers, ClientMessageUnpacker in, @Nullable Mapper<T> mapper, boolean partitionAwarenessEnabled, boolean sqlDirectMappingSupported) {
        this.ch = ch;
        this.resourceId = in.tryUnpackNil() ? null : Long.valueOf(in.unpackLong());
        this.hasRowSet = in.unpackBoolean();
        this.hasMorePages = in.unpackBoolean();
        this.wasApplied = in.unpackBoolean();
        this.affectedRows = in.unpackLong();
        this.metadata = ClientResultSetMetadata.read(in);
        this.partitionAwarenessMetadata = partitionAwarenessEnabled && !in.tryUnpackNil() ? ClientPartitionAwarenessMetadata.read(in, sqlDirectMappingSupported) : null;
        this.mapper = mapper;
        Marshaller marshaller = this.marshaller = this.metadata != null && mapper != null && mapper.targetType() != SqlRow.class ? ClientAsyncResultSet.marshaller(this.metadata, marshallers, mapper) : null;
        if (this.hasRowSet) {
            this.readRows(in);
        }
    }

    @Override
    @Nullable
    public ResultSetMetadata metadata() {
        return this.metadata;
    }

    @Override
    public boolean hasRowSet() {
        return this.hasRowSet;
    }

    @Override
    public long affectedRows() {
        return this.affectedRows;
    }

    @Override
    public boolean wasApplied() {
        return this.wasApplied;
    }

    @Override
    public Iterable<T> currentPage() {
        this.requireResultSet();
        return this.rows;
    }

    @Override
    public int currentPageSize() {
        this.requireResultSet();
        return this.rows.size();
    }

    @Override
    public CompletableFuture<? extends AsyncResultSet<T>> fetchNextPage() {
        this.requireResultSet();
        if (this.closed || !this.hasMorePages()) {
            return CompletableFuture.failedFuture(new CursorClosedException());
        }
        return this.ch.serviceAsync(51, w -> w.out().packLong(this.resourceId), r -> {
            this.readRows(r.in());
            this.hasMorePages = r.in().unpackBoolean();
            if (!this.hasMorePages) {
                this.closed = true;
            }
            return this;
        });
    }

    @Override
    public boolean hasMorePages() {
        return this.resourceId != null && this.hasMorePages;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.resourceId == null || this.closed) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.closed = true;
        return this.ch.serviceAsync(52, w -> w.out().packLong(this.resourceId), null);
    }

    @Nullable
    ClientPartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.partitionAwarenessMetadata;
    }

    private void requireResultSet() {
        if (!this.hasRowSet()) {
            throw new NoRowSetExpectedException();
        }
    }

    private void readRows(ClientMessageUnpacker in) {
        int size = in.unpackInt();
        int rowSize = this.metadata.columns().size();
        ArrayList<Object> res = new ArrayList<Object>(size);
        if (this.marshaller == null) {
            for (int i = 0; i < size; ++i) {
                BinaryTupleReader tupleReader = new BinaryTupleReader(rowSize, in.readBinary());
                res.add(new ClientSqlRow(tupleReader, this.metadata));
            }
        } else {
            try {
                for (int i = 0; i < size; ++i) {
                    BinaryTupleReader tupleReader = new BinaryTupleReader(rowSize, in.readBinaryUnsafe());
                    ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader, null, TuplePart.KEY_AND_VAL);
                    res.add(this.marshaller.readObject(reader, null));
                }
            }
            catch (MarshallerException e) {
                assert (this.mapper != null);
                throw new MarshallerException("Failed to map SQL result set to type '" + this.mapper.targetType() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        this.rows = Collections.unmodifiableList(res);
    }

    private static Object readValue(BinaryTupleReader in, int idx, ColumnMetadata col) {
        if (in.hasNullValue(idx)) {
            return null;
        }
        switch (col.type()) {
            case BOOLEAN: {
                return in.byteValue(idx) != 0;
            }
            case INT8: {
                return in.byteValue(idx);
            }
            case INT16: {
                return in.shortValue(idx);
            }
            case INT32: {
                return in.intValue(idx);
            }
            case INT64: {
                return in.longValue(idx);
            }
            case FLOAT: {
                return Float.valueOf(in.floatValue(idx));
            }
            case DOUBLE: {
                return in.doubleValue(idx);
            }
            case DECIMAL: {
                return in.decimalValue(idx, col.scale());
            }
            case DATE: {
                return in.dateValue(idx);
            }
            case TIME: {
                return in.timeValue(idx);
            }
            case DATETIME: {
                return in.dateTimeValue(idx);
            }
            case TIMESTAMP: {
                return in.timestampValue(idx);
            }
            case UUID: {
                return in.uuidValue(idx);
            }
            case STRING: {
                return in.stringValue(idx);
            }
            case BYTE_ARRAY: {
                return in.bytesValue(idx);
            }
            case PERIOD: {
                return in.periodValue(idx);
            }
            case DURATION: {
                return in.durationValue(idx);
            }
        }
        throw new UnsupportedOperationException("Unsupported column type: " + col.type());
    }

    private static <T> Marshaller marshaller(ResultSetMetadata metadata, MarshallersProvider marshallers, Mapper<T> mapper) {
        ClientColumn[] schemaColumns = new ClientColumn[metadata.columns().size()];
        List<ColumnMetadata> columns = metadata.columns();
        for (int i = 0; i < columns.size(); ++i) {
            ClientColumn schemaColumn;
            ColumnMetadata metaColumn = columns.get(i);
            schemaColumns[i] = schemaColumn = new ClientColumn(metaColumn.name(), metaColumn.type(), metaColumn.nullable(), i, -1, -1, i, metaColumn.scale(), metaColumn.precision());
        }
        ClientSchema schema = new ClientSchema(0, schemaColumns, marshallers);
        return schema.getMarshaller(mapper);
    }
}

