/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.ReadableByteChannelMock;
import org.apache.hc.core5.http.TruncatedChunkException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.ChunkDecoder;
import org.apache.hc.core5.http.impl.nio.CodecTestUtils;
import org.apache.hc.core5.http.impl.nio.SessionInputBufferImpl;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestChunkDecoder {
    TestChunkDecoder() {
    }

    @Test
    void testBasicDecoding() throws Exception {
        String s = "5\r\n01234\r\n5\r\n56789\r\n6\r\nabcdef\r\n0\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"5\r\n01234\r\n5\r\n56789\r\n6\r\nabcdef\r\n0\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)16, (int)bytesRead);
        Assertions.assertEquals((Object)"0123456789abcdef", (Object)CodecTestUtils.convert(dst));
        List trailers = decoder.getTrailers();
        Assertions.assertNull((Object)trailers);
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
        Assertions.assertEquals((Object)"[chunk-coded; completed: true]", (Object)decoder.toString());
    }

    @Test
    void testComplexDecoding() throws Exception {
        String s = "10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\nFooter2: fghij\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\nFooter2: fghij\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = 0;
        while (dst.hasRemaining() && !decoder.isCompleted()) {
            int i = decoder.read(dst);
            if (i <= 0) continue;
            bytesRead += i;
        }
        Assertions.assertEquals((int)26, (int)bytesRead);
        Assertions.assertEquals((Object)"12345678901234561234512345", (Object)CodecTestUtils.convert(dst));
        List trailers = decoder.getTrailers();
        Assertions.assertEquals((int)2, (int)trailers.size());
        Assertions.assertEquals((Object)"Footer1", (Object)((Header)trailers.get(0)).getName());
        Assertions.assertEquals((Object)"abcde", (Object)((Header)trailers.get(0)).getValue());
        Assertions.assertEquals((Object)"Footer2", (Object)((Header)trailers.get(1)).getName());
        Assertions.assertEquals((Object)"fghij", (Object)((Header)trailers.get(1)).getValue());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
    }

    @Test
    void testDecodingWithSmallBuffer() throws Exception {
        String s1 = "5\r\n01234\r\n5\r\n5678";
        String s2 = "9\r\n6\r\nabcdef\r\n0\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"5\r\n01234\r\n5\r\n5678", "9\r\n6\r\nabcdef\r\n0\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        ByteBuffer tmp = ByteBuffer.allocate(4);
        int bytesRead = 0;
        while (dst.hasRemaining() && !decoder.isCompleted()) {
            int i = decoder.read(tmp);
            if (i > 0) {
                bytesRead += i;
            }
            tmp.flip();
            dst.put(tmp);
            tmp.compact();
        }
        Assertions.assertEquals((int)16, (int)bytesRead);
        Assertions.assertEquals((Object)"0123456789abcdef", (Object)CodecTestUtils.convert(dst));
        Assertions.assertTrue((boolean)decoder.isCompleted());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
    }

    @Test
    void testMalformedChunk() {
        String s = "5\r\n01234--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"5\r\n01234--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(32, 32, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertThrows(MalformedChunkCodingException.class, () -> decoder.read(dst));
    }

    @Test
    void testIncompleteChunkDecoding() throws Exception {
        String[] chunks = new String[]{"10;", "key=\"value\"\r", "\n123456789012345", "6\r\n5\r\n12", "345\r\n6\r", "\nabcdef\r", "\n0\r\nFoot", "er1: abcde\r\nFooter2: f", "ghij\r\n\r\n"};
        ReadableByteChannelMock channel = new ReadableByteChannelMock(chunks, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ByteBuffer dst = ByteBuffer.allocate(1024);
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        int bytesRead = 0;
        while (dst.hasRemaining() && !decoder.isCompleted()) {
            int i = decoder.read(dst);
            if (i <= 0) continue;
            bytesRead += i;
        }
        Assertions.assertEquals((int)27, (int)bytesRead);
        Assertions.assertEquals((Object)"123456789012345612345abcdef", (Object)CodecTestUtils.convert(dst));
        Assertions.assertTrue((boolean)decoder.isCompleted());
        List trailers = decoder.getTrailers();
        Assertions.assertEquals((int)2, (int)trailers.size());
        Assertions.assertEquals((Object)"Footer1", (Object)((Header)trailers.get(0)).getName());
        Assertions.assertEquals((Object)"abcde", (Object)((Header)trailers.get(0)).getValue());
        Assertions.assertEquals((Object)"Footer2", (Object)((Header)trailers.get(1)).getName());
        Assertions.assertEquals((Object)"fghij", (Object)((Header)trailers.get(1)).getValue());
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)-1, (int)bytesRead);
        Assertions.assertTrue((boolean)decoder.isCompleted());
    }

    @Test
    void testMalformedChunkSizeDecoding() {
        String s = "5\r\n01234\r\n5zz\r\n56789\r\n6\r\nabcdef\r\n0\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"5\r\n01234\r\n5zz\r\n56789\r\n6\r\nabcdef\r\n0\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertThrows(MalformedChunkCodingException.class, () -> decoder.read(dst));
    }

    @Test
    void testMalformedChunkEndingDecoding() {
        String s = "5\r\n01234\r\n5\r\n56789\r\r6\r\nabcdef\r\n0\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"5\r\n01234\r\n5\r\n56789\r\r6\r\nabcdef\r\n0\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertThrows(MalformedChunkCodingException.class, () -> decoder.read(dst));
    }

    @Test
    void testMalformedChunkTruncatedChunk() throws Exception {
        String s = "3\r\n12";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"3\r\n12"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertEquals((int)2, (int)decoder.read(dst));
        Assertions.assertThrows(TruncatedChunkException.class, () -> decoder.read(dst));
    }

    @Test
    void testFoldedFooters() throws Exception {
        String s = "10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\n   \r\n  fghij\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\n   \r\n  fghij\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)26, (int)bytesRead);
        Assertions.assertEquals((Object)"12345678901234561234512345", (Object)CodecTestUtils.convert(dst));
        List trailers = decoder.getTrailers();
        Assertions.assertEquals((int)1, (int)trailers.size());
        Assertions.assertEquals((Object)"Footer1", (Object)((Header)trailers.get(0)).getName());
        Assertions.assertEquals((Object)"abcde  fghij", (Object)((Header)trailers.get(0)).getValue());
    }

    @Test
    void testMalformedFooters() {
        String s = "10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1 abcde\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1 abcde\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertThrows(IOException.class, () -> decoder.read(dst));
    }

    @Test
    void testMissingLastCRLF() {
        String s = "10\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertThrows(MalformedChunkCodingException.class, () -> {
            while (dst.hasRemaining() && !decoder.isCompleted()) {
                decoder.read(dst);
            }
        });
    }

    @Test
    void testMissingClosingChunk() {
        String s = "10\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        Assertions.assertThrows(ConnectionClosedException.class, () -> {
            long bytesRead = 0L;
            try {
                while (dst.hasRemaining() && !decoder.isCompleted()) {
                    int i = decoder.read(dst);
                    if (i <= 0) continue;
                    bytesRead += (long)i;
                }
            }
            catch (MalformedChunkCodingException ex) {
                Assertions.assertEquals((long)26L, (long)bytesRead);
                Assertions.assertEquals((Object)"12345678901234561234512345", (Object)CodecTestUtils.convert(dst));
                Assertions.assertTrue((boolean)decoder.isCompleted());
                throw ex;
            }
        });
    }

    @Test
    void testReadingWitSmallBuffer() throws Exception {
        String s = "10\r\n1234567890123456\r\n40\r\n1234567890123456123456789012345612345678901234561234567890123456\r\n0\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n40\r\n1234567890123456123456789012345612345678901234561234567890123456\r\n0\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        ByteBuffer tmp = ByteBuffer.allocate(10);
        int bytesRead = 0;
        while (dst.hasRemaining() && !decoder.isCompleted()) {
            int i = decoder.read(tmp);
            if (i <= 0) continue;
            bytesRead += i;
            tmp.flip();
            dst.put(tmp);
            tmp.compact();
        }
        Assertions.assertEquals((int)80, (int)bytesRead);
        Assertions.assertEquals((Object)"12345678901234561234567890123456123456789012345612345678901234561234567890123456", (Object)CodecTestUtils.convert(dst));
        Assertions.assertTrue((boolean)decoder.isCompleted());
    }

    @Test
    void testEndOfStreamConditionReadingFooters() throws Exception {
        String s = "10\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = 0;
        while (dst.hasRemaining() && !decoder.isCompleted()) {
            int i = decoder.read(dst);
            if (i <= 0) continue;
            bytesRead += i;
        }
        Assertions.assertEquals((int)26, (int)bytesRead);
        Assertions.assertEquals((Object)"12345678901234561234512345", (Object)CodecTestUtils.convert(dst));
        Assertions.assertTrue((boolean)decoder.isCompleted());
    }

    @Test
    void testTooLongChunkHeader() throws Exception {
        String s = "5; and some very looooong comment\r\n12345\r\n0\r\n";
        ReadableByteChannelMock channel1 = new ReadableByteChannelMock(new String[]{"5; and some very looooong comment\r\n12345\r\n0\r\n"}, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics1 = new BasicHttpTransportMetrics();
        SessionInputBufferImpl inbuf1 = new SessionInputBufferImpl(1024, 256);
        ChunkDecoder decoder1 = new ChunkDecoder((ReadableByteChannel)channel1, (SessionInputBuffer)inbuf1, metrics1);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        while (dst.hasRemaining() && !decoder1.isCompleted()) {
            decoder1.read(dst);
        }
        Assertions.assertEquals((Object)"12345", (Object)CodecTestUtils.convert(dst));
        Assertions.assertTrue((boolean)decoder1.isCompleted());
        ReadableByteChannelMock channel2 = new ReadableByteChannelMock(new String[]{"5; and some very looooong comment\r\n12345\r\n0\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf2 = new SessionInputBufferImpl(1024, 256, 10);
        BasicHttpTransportMetrics metrics2 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder2 = new ChunkDecoder((ReadableByteChannel)channel2, (SessionInputBuffer)inbuf2, metrics2);
        dst.clear();
        Assertions.assertThrows(MessageConstraintException.class, () -> decoder2.read(dst));
    }

    @Test
    void testTooLongFooter() throws Exception {
        String s = "10\r\n1234567890123456\r\n0\r\nFooter1: looooooooooooooooooooooooooooooooooooooooooooooooooooooog\r\n\r\n";
        ReadableByteChannelMock channel1 = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n0\r\nFooter1: looooooooooooooooooooooooooooooooooooooooooooooooooooooog\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf1 = new SessionInputBufferImpl(1024, 256, 0);
        BasicHttpTransportMetrics metrics1 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder1 = new ChunkDecoder((ReadableByteChannel)channel1, (SessionInputBuffer)inbuf1, metrics1);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder1.read(dst);
        Assertions.assertEquals((int)16, (int)bytesRead);
        Assertions.assertEquals((Object)"1234567890123456", (Object)CodecTestUtils.convert(dst));
        List trailers = decoder1.getTrailers();
        Assertions.assertNotNull((Object)trailers);
        Assertions.assertEquals((int)1, (int)trailers.size());
        ReadableByteChannelMock channel2 = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n0\r\nFooter1: looooooooooooooooooooooooooooooooooooooooooooooooooooooog\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf2 = new SessionInputBufferImpl(1024, 256, 25, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics2 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder2 = new ChunkDecoder((ReadableByteChannel)channel2, (SessionInputBuffer)inbuf2, metrics2);
        dst.clear();
        Assertions.assertThrows(MessageConstraintException.class, () -> decoder2.read(dst));
    }

    @Test
    void testTooLongFoldedFooter() throws Exception {
        String s = "10\r\n1234567890123456\r\n0\r\nFooter1: blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n\r\n";
        ReadableByteChannelMock channel1 = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n0\r\nFooter1: blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf1 = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics1 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder1 = new ChunkDecoder((ReadableByteChannel)channel1, (SessionInputBuffer)inbuf1, metrics1);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder1.read(dst);
        Assertions.assertEquals((int)16, (int)bytesRead);
        Assertions.assertEquals((Object)"1234567890123456", (Object)CodecTestUtils.convert(dst));
        List trailers = decoder1.getTrailers();
        Assertions.assertNotNull((Object)trailers);
        Assertions.assertEquals((int)1, (int)trailers.size());
        Http1Config http1Config = Http1Config.custom().setMaxLineLength(25).build();
        ReadableByteChannelMock channel2 = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n0\r\nFooter1: blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n  blah\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf2 = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics2 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder2 = new ChunkDecoder((ReadableByteChannel)channel2, (SessionInputBuffer)inbuf2, http1Config, metrics2);
        dst.clear();
        Assertions.assertThrows(MessageConstraintException.class, () -> decoder2.read(dst));
    }

    @Test
    void testTooManyFooters() throws Exception {
        String s = "10\r\n1234567890123456\r\n0\r\nFooter1: blah\r\nFooter2: blah\r\nFooter3: blah\r\nFooter4: blah\r\n\r\n";
        ReadableByteChannelMock channel1 = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n0\r\nFooter1: blah\r\nFooter2: blah\r\nFooter3: blah\r\nFooter4: blah\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf1 = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics1 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder1 = new ChunkDecoder((ReadableByteChannel)channel1, (SessionInputBuffer)inbuf1, metrics1);
        ByteBuffer dst = ByteBuffer.allocate(1024);
        int bytesRead = decoder1.read(dst);
        Assertions.assertEquals((int)16, (int)bytesRead);
        Assertions.assertEquals((Object)"1234567890123456", (Object)CodecTestUtils.convert(dst));
        List trailers = decoder1.getTrailers();
        Assertions.assertNotNull((Object)trailers);
        Assertions.assertEquals((int)4, (int)trailers.size());
        Http1Config http1Config = Http1Config.custom().setMaxHeaderCount(3).build();
        ReadableByteChannelMock channel2 = new ReadableByteChannelMock(new String[]{"10\r\n1234567890123456\r\n0\r\nFooter1: blah\r\nFooter2: blah\r\nFooter3: blah\r\nFooter4: blah\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf2 = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics2 = new BasicHttpTransportMetrics();
        ChunkDecoder decoder2 = new ChunkDecoder((ReadableByteChannel)channel2, (SessionInputBuffer)inbuf2, http1Config, metrics2);
        dst.clear();
        Assertions.assertThrows(MessageConstraintException.class, () -> decoder2.read(dst));
    }

    @Test
    void testInvalidConstructor() {
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"stuff;", "more stuff"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> new ChunkDecoder(null, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> TestChunkDecoder.lambda$testInvalidConstructor$12(channel, (SessionInputBuffer)inbuf));
    }

    @Test
    void testInvalidInput() {
        String s = "10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1 abcde\r\n\r\n";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n5\r\n12345\r\n0\r\nFooter1 abcde\r\n\r\n"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        Assertions.assertThrows(NullPointerException.class, () -> decoder.read(null));
    }

    @Test
    void testHugeChunk() throws Exception {
        String s = "1234567890abcdef\r\n0123456789abcdef";
        ReadableByteChannelMock channel = new ReadableByteChannelMock(new String[]{"1234567890abcdef\r\n0123456789abcdef"}, StandardCharsets.US_ASCII);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 256, 0, StandardCharsets.US_ASCII);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkDecoder decoder = new ChunkDecoder((ReadableByteChannel)channel, (SessionInputBuffer)inbuf, metrics);
        ByteBuffer dst = ByteBuffer.allocate(4);
        int bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)4, (int)bytesRead);
        Assertions.assertEquals((Object)"0123", (Object)CodecTestUtils.convert(dst));
        dst.clear();
        bytesRead = decoder.read(dst);
        Assertions.assertEquals((int)4, (int)bytesRead);
        Assertions.assertEquals((Object)"4567", (Object)CodecTestUtils.convert(dst));
    }

    private static /* synthetic */ void lambda$testInvalidConstructor$12(ReadableByteChannel channel, SessionInputBuffer inbuf) throws Throwable {
        new ChunkDecoder(channel, inbuf, null);
    }
}

