/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector.trimmer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.changedetector.trimmer.HelixPropertyTrimmer;
import org.apache.helix.model.ResourceConfig;

public class ResourceConfigTrimmer
extends HelixPropertyTrimmer<ResourceConfig> {
    private static final ResourceConfigTrimmer _resourceConfigTrimmer = new ResourceConfigTrimmer();
    private static final Map<HelixPropertyTrimmer.FieldType, Set<String>> STATIC_NON_TRIMMABLE_FIELD_MAP = ImmutableMap.of((Object)((Object)HelixPropertyTrimmer.FieldType.SIMPLE_FIELD), (Object)ImmutableSet.of((Object)ResourceConfig.ResourceConfigProperty.NUM_PARTITIONS.name(), (Object)ResourceConfig.ResourceConfigProperty.STATE_MODEL_DEF_REF.name(), (Object)ResourceConfig.ResourceConfigProperty.STATE_MODEL_FACTORY_NAME.name(), (Object)ResourceConfig.ResourceConfigProperty.MIN_ACTIVE_REPLICAS.name(), (Object)ResourceConfig.ResourceConfigProperty.REPLICAS.name(), (Object)ResourceConfig.ResourceConfigProperty.MAX_PARTITIONS_PER_INSTANCE.name(), (Object[])new String[]{ResourceConfig.ResourceConfigProperty.INSTANCE_GROUP_TAG.name(), ResourceConfig.ResourceConfigProperty.RESOURCE_GROUP_NAME.name(), ResourceConfig.ResourceConfigProperty.RESOURCE_TYPE.name()}), (Object)((Object)HelixPropertyTrimmer.FieldType.MAP_FIELD), (Object)ImmutableSet.of((Object)ResourceConfig.ResourceConfigProperty.PARTITION_CAPACITY_MAP.name()));

    private ResourceConfigTrimmer() {
    }

    @Override
    protected Map<HelixPropertyTrimmer.FieldType, Set<String>> getNonTrimmableFields(ResourceConfig resourceConfig) {
        HashMap<HelixPropertyTrimmer.FieldType, Set<String>> nonTrimmableFields = new HashMap<HelixPropertyTrimmer.FieldType, Set<String>>(STATIC_NON_TRIMMABLE_FIELD_MAP);
        nonTrimmableFields.put(HelixPropertyTrimmer.FieldType.LIST_FIELD, resourceConfig.getRecord().getListFields().keySet());
        return nonTrimmableFields;
    }

    @Override
    public ResourceConfig trimProperty(ResourceConfig property) {
        return new ResourceConfig(this.doTrim(property));
    }

    public static ResourceConfigTrimmer getInstance() {
        return _resourceConfigTrimmer;
    }
}

