/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.bool;

import org.apache.directory.api.ldap.model.schema.syntaxCheckers.BooleanSyntaxChecker;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractInPlaceStringValueEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class InPlaceBooleanValueEditor
extends AbstractInPlaceStringValueEditor {
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";

    public InPlaceBooleanValueEditor() {
        this.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                block27: {
                    String stringValue;
                    if (!(value instanceof String)) break block27;
                    switch (stringValue = ((String)value).toUpperCase()) {
                        case "": 
                        case "0": 
                        case "1": 
                        case "F": 
                        case "N": 
                        case "T": 
                        case "Y": 
                        case "NO": 
                        case "YES": 
                        case "TRUE": 
                        case "FALSE": {
                            return null;
                        }
                    }
                    return "Invalid boolean";
                }
                return "Invalid boolean";
            }
        });
    }

    protected Object doGetValue() {
        Object value;
        block28: {
            value = super.doGetValue();
            if (!(value instanceof String)) break block28;
            String stringValue = (String)value;
            switch (stringValue.toUpperCase()) {
                case "0": 
                case "F": 
                case "N": 
                case "NO": 
                case "FALSE": {
                    return FALSE;
                }
                case "": 
                case "1": 
                case "T": 
                case "Y": 
                case "YES": 
                case "TRUE": {
                    return TRUE;
                }
            }
            return stringValue;
        }
        return value;
    }

    public boolean isValueValid() {
        return this.doGetValue() != null;
    }

    public Object getRawValue(IValue value) {
        Object rawValue = super.getRawValue(value);
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (stringValue.length() == 0 || BooleanSyntaxChecker.INSTANCE.isValidSyntax((Object)stringValue)) {
                return rawValue;
            }
            return null;
        }
        if (rawValue == null) {
            return TRUE;
        }
        return null;
    }
}

