/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.widget.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CoreSchemasSelectionWidget {
    private static final String[] coreSchemasFromApacheDS = new String[]{"adsconfig", "apache", "apachedns", "apachemeta", "autofs", "collective", "corba", "core", "cosine", "dhcp", "inetorgperson", "java", "krb5kdc", "mozilla", "nis", "pwdpolicy", "samba", "system"};
    private static final String[] coreSchemasFromOpenLdap = new String[]{"collective", "corba", "core", "cosine", "dyngroup", "duaconf", "inetorgperson", "java", "misc", "nis", "openldap", "ppolicy", "system"};
    private Button typeApacheDSButton;
    private Button typeOpenLDAPButton;
    private CheckboxTableViewer coreSchemasTableViewer;

    public Composite createWidget(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group serverTypeGroup = new Group(composite, 0);
        serverTypeGroup.setText(Messages.getString("CoreSchemasSelectionWidget.ServerType"));
        serverTypeGroup.setLayout((Layout)new GridLayout(2, false));
        serverTypeGroup.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.typeApacheDSButton = new Button((Composite)serverTypeGroup, 16);
        this.typeApacheDSButton.setText(Messages.getString("CoreSchemasSelectionWidget.ApacheDS"));
        this.typeApacheDSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreSchemasSelectionWidget.this.resetTableViewerWithCoreSchemasFromApacheDS();
            }
        });
        this.typeOpenLDAPButton = new Button((Composite)serverTypeGroup, 16);
        this.typeOpenLDAPButton.setText(Messages.getString("CoreSchemasSelectionWidget.OpenLDAP"));
        this.typeOpenLDAPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreSchemasSelectionWidget.this.resetTableViewerWithCoreSchemasFromOpenLdap();
            }
        });
        Label coreSchemaslabel = new Label(composite, 0);
        coreSchemaslabel.setText(Messages.getString("CoreSchemasSelectionWidget.ChooseCoreSchemas"));
        coreSchemaslabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.coreSchemasTableViewer = new CheckboxTableViewer(new Table(composite, 67616));
        GridData gridData = new GridData(4, 4, true, true, 1, 2);
        gridData.heightHint = 127;
        this.coreSchemasTableViewer.getTable().setLayoutData((Object)gridData);
        this.coreSchemasTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.coreSchemasTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage("resources/icons/schema.gif");
            }
        });
        Button coreSchemasTableSelectAllButton = new Button(composite, 8);
        coreSchemasTableSelectAllButton.setText(Messages.getString("CoreSchemasSelectionWidget.SelectAll"));
        coreSchemasTableSelectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        coreSchemasTableSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreSchemasSelectionWidget.this.coreSchemasTableViewer.setAllChecked(true);
            }
        });
        Button coreSchemasTableDeselectAllButton = new Button(composite, 8);
        coreSchemasTableDeselectAllButton.setText(Messages.getString("CoreSchemasSelectionWidget.DeselectAll"));
        coreSchemasTableDeselectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        coreSchemasTableDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreSchemasSelectionWidget.this.coreSchemasTableViewer.setAllChecked(false);
            }
        });
        return composite;
    }

    public String[] getCheckedCoreSchemas() {
        return Arrays.asList(this.coreSchemasTableViewer.getCheckedElements()).toArray(new String[0]);
    }

    public String[] getGrayedCoreSchemas() {
        return Arrays.asList(this.coreSchemasTableViewer.getGrayedElements()).toArray(new String[0]);
    }

    public String[] getSelectedCoreSchemas() {
        ArrayList<String> selectedSchemas = new ArrayList<String>();
        selectedSchemas.addAll(Arrays.asList(this.getCheckedCoreSchemas()));
        selectedSchemas.removeAll(Arrays.asList(this.getGrayedCoreSchemas()));
        return selectedSchemas.toArray(new String[0]);
    }

    public ServerTypeEnum getServerType() {
        if (this.typeApacheDSButton.getSelection()) {
            return ServerTypeEnum.APACHE_DS;
        }
        if (this.typeOpenLDAPButton.getSelection()) {
            return ServerTypeEnum.OPENLDAP;
        }
        return null;
    }

    public void init(ServerTypeEnum selectedButton) {
        if (selectedButton != null) {
            switch (selectedButton) {
                case APACHE_DS: {
                    this.typeApacheDSButton.setSelection(true);
                    this.resetTableViewerWithCoreSchemasFromApacheDS();
                    break;
                }
                case OPENLDAP: {
                    this.typeOpenLDAPButton.setSelection(true);
                    this.resetTableViewerWithCoreSchemasFromOpenLdap();
                }
            }
        }
    }

    private void resetTableViewerWithCoreSchemasFromApacheDS() {
        this.coreSchemasTableViewer.setAllChecked(false);
        this.coreSchemasTableViewer.setInput((Object)coreSchemasFromApacheDS);
    }

    private void resetTableViewerWithCoreSchemasFromOpenLdap() {
        this.coreSchemasTableViewer.setAllChecked(false);
        this.coreSchemasTableViewer.setInput((Object)coreSchemasFromOpenLdap);
    }

    public void setCheckedCoreSchemas(String[] checkedCoreSchemas) {
        this.coreSchemasTableViewer.setCheckedElements((Object[])checkedCoreSchemas);
    }

    public void setGrayedCoreSchemas(String[] grayedCoreSchemas) {
        this.coreSchemasTableViewer.setGrayedElements((Object[])grayedCoreSchemas);
    }

    public static enum ServerTypeEnum {
        APACHE_DS,
        OPENLDAP;

    }
}

