/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor;

import org.apache.directory.studio.ldapbrowser.common.widgets.DialogContentAssistant;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifeditor.editor.reconciler.LdifReconcilingStrategy;
import org.apache.directory.studio.ldifeditor.editor.text.LdifAnnotationHover;
import org.apache.directory.studio.ldifeditor.editor.text.LdifAutoEditStrategy;
import org.apache.directory.studio.ldifeditor.editor.text.LdifCompletionProcessor;
import org.apache.directory.studio.ldifeditor.editor.text.LdifDamagerRepairer;
import org.apache.directory.studio.ldifeditor.editor.text.LdifDoubleClickStrategy;
import org.apache.directory.studio.ldifeditor.editor.text.LdifTextHover;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class LdifSourceViewerConfiguration
extends SourceViewerConfiguration {
    private ILdifEditor editor;
    private LdifAnnotationHover annotationHover;
    private LdifTextHover textHover;
    private PresentationReconciler presentationReconciler;
    private LdifDamagerRepairer damagerRepairer;
    private boolean contentAssistEnabled;
    private ContentAssistant contentAssistant;
    private IContentAssistProcessor contentAssistProcessor;
    private LdifDoubleClickStrategy doubleClickStrategy;
    private MonoReconciler reconciler;
    private LdifReconcilingStrategy reconcilingStrategy;
    private IAutoEditStrategy[] autoEditStrategies;

    public LdifSourceViewerConfiguration(ILdifEditor editor, boolean contentAssistEnabled) {
        this.editor = editor;
        this.contentAssistEnabled = contentAssistEnabled;
    }

    public void setTextAttribute(String key, RGB rgb, int style) {
        this.damagerRepairer.setTextAttribute(key, rgb, style);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "org.apache.directory.studio.ldifeditor.LdifPartitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__ldif_record"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new LdifDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.presentationReconciler == null) {
            this.presentationReconciler = new PresentationReconciler();
            this.presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.damagerRepairer = new LdifDamagerRepairer(this.editor);
            this.presentationReconciler.setDamager((IPresentationDamager)this.damagerRepairer, "__dftl_partition_content_type");
            this.presentationReconciler.setRepairer((IPresentationRepairer)this.damagerRepairer, "__dftl_partition_content_type");
            this.presentationReconciler.setDamager((IPresentationDamager)this.damagerRepairer, "__ldif_record");
            this.presentationReconciler.setRepairer((IPresentationRepairer)this.damagerRepairer, "__ldif_record");
        }
        return this.presentationReconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler == null) {
            this.reconcilingStrategy = new LdifReconcilingStrategy(this.editor);
            this.reconciler = new MonoReconciler((IReconcilingStrategy)this.reconcilingStrategy, true);
            this.reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            this.reconciler.setDelay(500);
        }
        return this.reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.contentAssistEnabled) {
            if (this.contentAssistant == null) {
                this.contentAssistant = new DialogContentAssistant();
                this.contentAssistProcessor = new LdifCompletionProcessor(this.editor, this.contentAssistant);
                this.contentAssistant.setContentAssistProcessor(this.contentAssistProcessor, "__ldif_record");
                this.contentAssistant.setContentAssistProcessor(this.contentAssistProcessor, "__dftl_partition_content_type");
                this.contentAssistant.setDocumentPartitioning("org.apache.directory.studio.ldifeditor.LdifPartitioning");
                this.contentAssistant.setContextInformationPopupOrientation(20);
                this.contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
                IPreferenceStore store = LdifEditorActivator.getDefault().getPreferenceStore();
                this.contentAssistant.enableAutoInsert(store.getBoolean("ldifEditorCodeAssistInsertSingleProposalAuto"));
                this.contentAssistant.enableAutoActivation(store.getBoolean("ldifEditorCodeAssistEnableAutoActivation"));
                this.contentAssistant.setAutoActivationDelay(store.getInt("ldifEditorCodeAssistAutoActivationDelay"));
            }
            return this.contentAssistant;
        }
        return null;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.annotationHover == null) {
            this.annotationHover = new LdifAnnotationHover(this.editor);
        }
        return this.annotationHover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover == null) {
            this.textHover = new LdifTextHover(this.editor);
        }
        return this.textHover;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.autoEditStrategies == null) {
            this.autoEditStrategies = new IAutoEditStrategy[2];
            this.autoEditStrategies[0] = new DefaultIndentLineAutoEditStrategy();
            this.autoEditStrategies[1] = new LdifAutoEditStrategy(this.editor);
        }
        return this.autoEditStrategies;
    }
}

