/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.wizards;

import java.util.regex.Pattern;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.LdapServersPlugin;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.wizards.LdapServerAdapterExtensionsContentProvider;
import org.apache.directory.studio.ldapservers.wizards.LdapServerAdapterExtensionsLabelProvider;
import org.apache.directory.studio.ldapservers.wizards.Messages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class NewServerWizardSelectionPage
extends WizardPage {
    private LdapServersManager ldapServersManager;
    private LdapServerAdapterExtensionsContentProvider contentProvider;
    private LdapServerAdapterExtensionsLabelProvider labelProvider;
    private Label filterLabel;
    private Text filterText;
    private TreeViewer ldapServerAdaptersTreeViewer;
    private Text serverNameText;

    public NewServerWizardSelectionPage() {
        super(NewServerWizardSelectionPage.class.getCanonicalName());
        this.setTitle(Messages.getString("NewServerWizardSelectionPage.CreateAnLdapServer"));
        this.setDescription(Messages.getString("NewServerWizardSelectionPage.ChooseTypeOfServerAndSpecifyName"));
        this.setImageDescriptor(LdapServersPlugin.getDefault().getImageDescriptor("resources/icons/server_new_wizard.png"));
        this.setPageComplete(false);
        this.ldapServersManager = LdapServersManager.getDefault();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.filterLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("NewServerWizardSelectionPage.SelectServerType"), (int)2);
        this.filterLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.filterText = new Text(composite, 2432);
        this.filterText.setMessage(Messages.getString("NewServerWizardSelectionPage.TypeFilterHere"));
        this.filterText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.ldapServerAdaptersTreeViewer = new TreeViewer(new Tree(composite, 2820));
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = 90;
        this.ldapServerAdaptersTreeViewer.getTree().setLayoutData((Object)gd);
        this.contentProvider = new LdapServerAdapterExtensionsContentProvider();
        this.ldapServerAdaptersTreeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new LdapServerAdapterExtensionsLabelProvider();
        this.ldapServerAdaptersTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.ldapServerAdaptersTreeViewer.setInput((Object)"LDAP Server Adapters Tree Viewer Input");
        this.ldapServerAdaptersTreeViewer.expandAll();
        this.ldapServerAdaptersTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof String) {
                    Object[] children;
                    Object[] objectArray = children = NewServerWizardSelectionPage.this.contentProvider.getChildren(element);
                    if (children.length != 0) {
                        Object child = objectArray[0];
                        String label = NewServerWizardSelectionPage.this.labelProvider.getText(child);
                        return this.getFilterPattern().matcher(label).matches();
                    }
                } else if (element instanceof LdapServerAdapterExtension) {
                    String label = NewServerWizardSelectionPage.this.labelProvider.getText(element);
                    return this.getFilterPattern().matcher(label).matches();
                }
                return false;
            }

            private Pattern getFilterPattern() {
                String filter = NewServerWizardSelectionPage.this.filterText.getText();
                return Pattern.compile(filter == null ? ".*" : ".*" + filter + ".*", 2);
            }
        });
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(0, 0, true, false, 2, 1));
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("NewServerWizardSelectionPage.ServerName"), (int)1);
        this.serverNameText = BaseWidgetUtils.createText((Composite)composite, (String)"", (int)1);
        this.addListeners();
        this.setControl((Control)composite);
        composite.setFocus();
    }

    private void addListeners() {
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewServerWizardSelectionPage.this.ldapServerAdaptersTreeViewer.refresh();
                NewServerWizardSelectionPage.this.ldapServerAdaptersTreeViewer.expandAll();
            }
        });
        this.ldapServerAdaptersTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewServerWizardSelectionPage.this.serverNameText.setText(this.getServerName((StructuredSelection)NewServerWizardSelectionPage.this.ldapServerAdaptersTreeViewer.getSelection()));
                NewServerWizardSelectionPage.this.validate();
            }

            private String getServerName(StructuredSelection selection) {
                Object selectedObject;
                if (!selection.isEmpty() && (selectedObject = selection.getFirstElement()) instanceof LdapServerAdapterExtension) {
                    String serverName = NewServerWizardSelectionPage.this.labelProvider.getText(selection.getFirstElement());
                    if (NewServerWizardSelectionPage.this.ldapServersManager.isNameAvailable(serverName)) {
                        return serverName;
                    }
                    String newServerName = serverName;
                    int i = 2;
                    while (!NewServerWizardSelectionPage.this.ldapServersManager.isNameAvailable(newServerName)) {
                        newServerName = String.valueOf(serverName) + " (" + i + ")";
                        ++i;
                    }
                    return newServerName;
                }
                return "";
            }
        });
        this.serverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewServerWizardSelectionPage.this.validate();
            }
        });
    }

    private void validate() {
        this.displayErrorMessage(null);
        StructuredSelection selection = (StructuredSelection)this.ldapServerAdaptersTreeViewer.getSelection();
        if (selection.isEmpty()) {
            this.displayErrorMessage(Messages.getString("NewServerWizardSelectionPage.ChooseTypeOfServerToCreate"));
            return;
        }
        Object selectedObject = selection.getFirstElement();
        if (selectedObject instanceof String) {
            this.displayErrorMessage(Messages.getString("NewServerWizardSelectionPage.ChooseTypeOfServerToCreate"));
            return;
        }
        String name = this.serverNameText.getText();
        if (name != null) {
            if ("".equals(name)) {
                this.displayErrorMessage(Messages.getString("NewServerWizardSelectionPage.EnterANameForLdapServer"));
                return;
            }
            if (!this.ldapServersManager.isNameAvailable(name)) {
                this.displayErrorMessage(Messages.getString("NewServerWizardSelectionPage.LdapServerWithSameNameAlreadyExists"));
                return;
            }
        }
    }

    protected void displayErrorMessage(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getServerName() {
        return this.serverNameText.getText();
    }

    public LdapServerAdapterExtension getLdapServerAdapterExtension() {
        Object selectedObject;
        StructuredSelection selection = (StructuredSelection)this.ldapServerAdaptersTreeViewer.getSelection();
        if (!selection.isEmpty() && (selectedObject = selection.getFirstElement()) instanceof LdapServerAdapterExtension) {
            return (LdapServerAdapterExtension)selectedObject;
        }
        return null;
    }
}

