/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.nio.charset.Charset;
import org.apache.directory.studio.ldapbrowser.common.widgets.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.OptionsInput;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;

public class FileEncodingInput
extends OptionsInput {
    public FileEncodingInput(String initialRawValue, boolean asGroup) {
        super(Messages.getString("FileEncodingInput.FileEncoding"), FileEncodingInput.getDefaultDisplayValue(), FileEncodingInput.getDefaultRawValue(), FileEncodingInput.getOtherDisplayValues(), FileEncodingInput.getOtherRawValues(), initialRawValue, asGroup, false);
    }

    private static String getDefaultDisplayValue() {
        return FileEncodingInput.getCharsetDisplayValue(FileEncodingInput.getDefaultRawValue());
    }

    private static String getDefaultRawValue() {
        return BrowserCoreConstants.DEFAULT_ENCODING;
    }

    private static String[] getOtherDisplayValues() {
        String[] otherEncodingsRawValues = FileEncodingInput.getOtherRawValues();
        String[] otherEncodingsDisplayValues = new String[otherEncodingsRawValues.length];
        int i = 0;
        while (i < otherEncodingsDisplayValues.length) {
            String rawValue = otherEncodingsRawValues[i];
            otherEncodingsDisplayValues[i] = FileEncodingInput.getCharsetDisplayValue(rawValue);
            ++i;
        }
        return otherEncodingsDisplayValues;
    }

    private static String[] getOtherRawValues() {
        String[] otherEncodingsRawValues = Charset.availableCharsets().keySet().toArray(new String[0]);
        return otherEncodingsRawValues;
    }

    private static String getCharsetDisplayValue(String charsetRawValue) {
        try {
            Charset charset = Charset.forName(charsetRawValue);
            return charset.displayName();
        }
        catch (Exception exception) {
            return charsetRawValue;
        }
    }
}

