/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class BrowserAction
extends StudioAction
implements IWorkbenchWindowActionDelegate {
    private BrowserCategory[] selectedBrowserViewCategories;
    private IEntry[] selectedEntries;
    private BrowserEntryPage[] selectedBrowserEntryPages;
    private ISearch[] selectedSearches;
    private ISearchResult[] selectedSearchResults;
    private BrowserSearchResultPage[] selectedBrowserSearchResultPages;
    private IBookmark[] selectedBookmarks;
    private IAttribute[] selectedAttributes;
    private AttributeHierarchy[] selectedAttributeHierarchies;
    private IValue[] selectedValues;
    private LdifFile selectedLdifModel;
    private LdifContainer[] selectedLdifContainers;
    private LdifPart[] selectedLdifParts;
    protected String[] selectedProperties;
    private Object input;

    protected BrowserAction() {
        this.init();
    }

    public void init(IWorkbenchWindow window) {
        this.init();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelectedBrowserViewCategories(BrowserSelectionUtils.getBrowserViewCategories(selection));
        this.setSelectedEntries(BrowserSelectionUtils.getEntries(selection));
        this.setSelectedBrowserEntryPages(BrowserSelectionUtils.getBrowserEntryPages(selection));
        this.setSelectedSearchResults(BrowserSelectionUtils.getSearchResults(selection));
        this.setSelectedBrowserSearchResultPages(BrowserSelectionUtils.getBrowserSearchResultPages(selection));
        this.setSelectedBookmarks(BrowserSelectionUtils.getBookmarks(selection));
        this.setSelectedSearches(BrowserSelectionUtils.getSearches(selection));
        this.setSelectedAttributes(BrowserSelectionUtils.getAttributes(selection));
        this.setSelectedAttributeHierarchies(BrowserSelectionUtils.getAttributeHierarchie(selection));
        this.setSelectedValues(BrowserSelectionUtils.getValues(selection));
        action.setEnabled(this.isEnabled());
        action.setText(this.getText());
        action.setToolTipText(this.getText());
    }

    public abstract String getText();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract String getCommandId();

    public abstract boolean isEnabled();

    public abstract void run();

    private void init() {
        this.selectedBrowserViewCategories = new BrowserCategory[0];
        this.selectedEntries = new IEntry[0];
        this.selectedBrowserEntryPages = new BrowserEntryPage[0];
        this.selectedSearches = new ISearch[0];
        this.selectedSearchResults = new ISearchResult[0];
        this.selectedBrowserSearchResultPages = new BrowserSearchResultPage[0];
        this.selectedBookmarks = new IBookmark[0];
        this.selectedAttributes = new IAttribute[0];
        this.selectedAttributeHierarchies = new AttributeHierarchy[0];
        this.selectedValues = new IValue[0];
        this.selectedLdifModel = null;
        this.selectedLdifContainers = new LdifContainer[0];
        this.selectedLdifParts = new LdifPart[0];
        this.selectedProperties = new String[0];
        this.input = null;
    }

    public void dispose() {
        this.selectedBrowserViewCategories = new BrowserCategory[0];
        this.selectedEntries = new IEntry[0];
        this.selectedBrowserEntryPages = new BrowserEntryPage[0];
        this.selectedSearches = new ISearch[0];
        this.selectedSearchResults = new ISearchResult[0];
        this.selectedBrowserSearchResultPages = new BrowserSearchResultPage[0];
        this.selectedBookmarks = new IBookmark[0];
        this.selectedAttributes = new IAttribute[0];
        this.selectedAttributeHierarchies = new AttributeHierarchy[0];
        this.selectedValues = new IValue[0];
        this.selectedLdifModel = null;
        this.selectedLdifContainers = new LdifContainer[0];
        this.selectedLdifParts = new LdifPart[0];
        this.selectedProperties = new String[0];
        this.input = null;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    public IAttribute[] getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public void setSelectedAttributes(IAttribute[] selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    public IBookmark[] getSelectedBookmarks() {
        return this.selectedBookmarks;
    }

    public void setSelectedBookmarks(IBookmark[] selectedBookmarks) {
        this.selectedBookmarks = selectedBookmarks;
    }

    public BrowserCategory[] getSelectedBrowserViewCategories() {
        return this.selectedBrowserViewCategories;
    }

    public void setSelectedBrowserViewCategories(BrowserCategory[] selectedBrowserViewCategories) {
        this.selectedBrowserViewCategories = selectedBrowserViewCategories;
    }

    public IEntry[] getSelectedEntries() {
        return this.selectedEntries;
    }

    public void setSelectedEntries(IEntry[] selectedEntries) {
        this.selectedEntries = selectedEntries;
    }

    public ISearch[] getSelectedSearches() {
        return this.selectedSearches;
    }

    public void setSelectedSearches(ISearch[] selectedSearches) {
        this.selectedSearches = selectedSearches;
    }

    public ISearchResult[] getSelectedSearchResults() {
        return this.selectedSearchResults;
    }

    public void setSelectedSearchResults(ISearchResult[] selectedSearchResults) {
        this.selectedSearchResults = selectedSearchResults;
    }

    public IValue[] getSelectedValues() {
        return this.selectedValues;
    }

    public void setSelectedValues(IValue[] selectedValues) {
        this.selectedValues = selectedValues;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public LdifContainer[] getSelectedLdifContainers() {
        return this.selectedLdifContainers;
    }

    public void setSelectedLdifContainers(LdifContainer[] selectedLdifContainers) {
        this.selectedLdifContainers = selectedLdifContainers;
    }

    public LdifFile getSelectedLdifModel() {
        return this.selectedLdifModel;
    }

    public void setSelectedLdifModel(LdifFile selectedLdifModel) {
        this.selectedLdifModel = selectedLdifModel;
    }

    public LdifPart[] getSelectedLdifParts() {
        return this.selectedLdifParts;
    }

    public void setSelectedLdifParts(LdifPart[] selectedLdifParts) {
        this.selectedLdifParts = selectedLdifParts;
    }

    public BrowserEntryPage[] getSelectedBrowserEntryPages() {
        return this.selectedBrowserEntryPages;
    }

    public void setSelectedBrowserEntryPages(BrowserEntryPage[] selectedBrowserEntryPages) {
        this.selectedBrowserEntryPages = selectedBrowserEntryPages;
    }

    public BrowserSearchResultPage[] getSelectedBrowserSearchResultPages() {
        return this.selectedBrowserSearchResultPages;
    }

    public void setSelectedBrowserSearchResultPages(BrowserSearchResultPage[] selectedBrowserSearchResultPages) {
        this.selectedBrowserSearchResultPages = selectedBrowserSearchResultPages;
    }

    public AttributeHierarchy[] getSelectedAttributeHierarchies() {
        return this.selectedAttributeHierarchies;
    }

    public void setSelectedAttributeHierarchies(AttributeHierarchy[] ahs) {
        this.selectedAttributeHierarchies = ahs;
    }

    public String[] getSelectedProperties() {
        return this.selectedProperties;
    }

    public void setSelectedProperties(String[] selectedProperties) {
        this.selectedProperties = selectedProperties;
    }
}

