/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequestHandler
extends LdapRequestHandler<AddRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AddRequestHandler.class);

    @Override
    public void handle(LdapSession session, AddRequest addRequest) {
        LOG.debug("Handling request: {}", (Object)addRequest);
        AddResponse addResponse = (AddResponse)addRequest.getResultResponse();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.add(addRequest);
            LdapResult result = addResponse.getLdapResult();
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)addResponse);
        }
        catch (Exception e) {
            this.handleException(session, (ResultResponseRequest)addRequest, (ResultResponse)addResponse, e);
        }
    }
}

