/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.NonNativeValueLayouts;
import org.apache.datasketches.memory.internal.WritableMemoryImpl;

final class NonNativeWritableMemoryImpl
extends WritableMemoryImpl {
    NonNativeWritableMemoryImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr, Arena arena) {
        super(seg, typeId, memReqSvr, arena);
    }

    @Override
    public char getChar(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        MemorySegment.copy(this.seg, NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, dstArray, dstOffsetChars, lengthChars);
    }

    @Override
    public double getDouble(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        MemorySegment.copy(this.seg, NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, dstArray, dstOffsetDoubles, lengthDoubles);
    }

    @Override
    public float getFloat(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        MemorySegment.copy(this.seg, NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, dstArray, dstOffsetFloats, lengthFloats);
    }

    @Override
    public int getInt(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        MemorySegment.copy(this.seg, NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, dstArray, dstOffsetInts, lengthInts);
    }

    @Override
    public long getLong(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        MemorySegment.copy(this.seg, NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, dstArray, dstOffsetLongs, lengthLongs);
    }

    @Override
    public short getShort(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        MemorySegment.copy(this.seg, NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, dstArray, dstOffsetShorts, lengthShorts);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.seg.set(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        MemorySegment.copy(srcArray, srcOffsetChars, this.seg, NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, lengthChars);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.seg.set(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        MemorySegment.copy(srcArray, srcOffsetDoubles, this.seg, NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, lengthDoubles);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.seg.set(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        MemorySegment.copy(srcArray, srcOffsetFloats, this.seg, NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, lengthFloats);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.seg.set(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        MemorySegment.copy(srcArray, srcOffsetInts, this.seg, NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, lengthInts);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.seg.set(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        MemorySegment.copy(srcArray, srcOffsetLongs, this.seg, NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, lengthLongs);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.seg.set(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        MemorySegment.copy(srcArray, srcOffsetShorts, this.seg, NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, lengthShorts);
    }
}

