/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Slot;

public class BuiltInSlot<T extends ScriptableObject>
extends Slot {
    private final Getter<T> getter;
    private final Setter<T> setter;
    private final AttributeSetter<T> attrUpdater;
    private final PropDescriptionSetter<T> propDescSetter;

    BuiltInSlot(Object name, int index, int attr, T builtIn, Getter<T> getter) {
        this(name, index, attr, (ScriptableObject)builtIn, (Getter<ScriptableObject>)getter, BuiltInSlot::defaultSetter, BuiltInSlot::defaultAttrSetter, BuiltInSlot::defaultPropDescSetter);
    }

    BuiltInSlot(Object name, int index, int attr, T builtIn, Getter<T> getter, Setter<T> setter) {
        this(name, index, attr, (ScriptableObject)builtIn, (Getter<ScriptableObject>)getter, (Setter<ScriptableObject>)setter, BuiltInSlot::defaultAttrSetter, BuiltInSlot::defaultPropDescSetter);
    }

    BuiltInSlot(Object name, int index, int attr, T builtIn, Getter<T> getter, Setter<T> setter, AttributeSetter<T> attrUpdater) {
        this(name, index, attr, (ScriptableObject)builtIn, (Getter<ScriptableObject>)getter, (Setter<ScriptableObject>)setter, (AttributeSetter<ScriptableObject>)attrUpdater, BuiltInSlot::defaultPropDescSetter);
    }

    BuiltInSlot(Object name, int index, int attr, T builtIn, Getter<T> getter, Setter<T> setter, AttributeSetter<T> attrUpdater, PropDescriptionSetter<T> propDescSetter) {
        super(name, index, attr);
        this.value = builtIn;
        this.getter = getter;
        this.setter = setter;
        this.attrUpdater = attrUpdater;
        this.propDescSetter = propDescSetter;
    }

    BuiltInSlot(BuiltInSlot<T> slot) {
        super(slot);
        this.getter = slot.getter;
        this.setter = slot.setter;
        this.attrUpdater = slot.attrUpdater;
        this.propDescSetter = slot.propDescSetter;
    }

    @Override
    Slot copySlot() {
        BuiltInSlot<T> res = new BuiltInSlot<T>(this);
        res.next = null;
        res.orderedNext = null;
        return res;
    }

    @Override
    public Object getValue(Scriptable start) {
        return this.getter.apply((ScriptableObject)this.value, start);
    }

    @Override
    public boolean setValue(Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        if ((this.getAttributes() & 1) != 0) {
            if (isThrow) {
                throw ScriptRuntime.typeErrorById("msg.modify.readonly", this.name);
            }
            return true;
        }
        if (owner == start) {
            return this.setter.apply((ScriptableObject)this.value, value, owner, start, isThrow);
        }
        return false;
    }

    public void setValueFromDescriptor(Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        this.setter.apply((ScriptableObject)this.value, value, owner, start, isThrow);
    }

    @Override
    void setAttributes(int value) {
        this.attrUpdater.apply((ScriptableObject)this.value, value);
        super.setAttributes(value);
    }

    @Override
    ScriptableObject.DescriptorInfo getPropertyDescriptor(Context cx, Scriptable scope) {
        return ScriptableObject.buildDataDescriptor(this.getValue((ScriptableObject)this.value), this.getAttributes());
    }

    boolean applyNewDescriptor(Object id, ScriptableObject.DescriptorInfo info, boolean checkValid, Object key, int index) {
        return this.propDescSetter.apply((ScriptableObject)this.value, this, id, info, checkValid, key, index);
    }

    private static <T extends ScriptableObject> boolean defaultSetter(T builtIn, Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        return true;
    }

    private static <T extends ScriptableObject> void defaultAttrSetter(T builtIn, int attributes) {
    }

    private static <T extends ScriptableObject> boolean defaultPropDescSetter(T builtIn, BuiltInSlot<T> current, Object id, ScriptableObject.DescriptorInfo info, boolean checkValid, Object key, int index) {
        try (CompoundOperationMap map = builtIn.startCompoundOp(true);){
            boolean bl = ScriptableObject.defineOrdinaryProperty(ScriptableObject::setSlotValue, builtIn, map, id, info, checkValid, key, index);
            return bl;
        }
    }

    public static interface Setter<U extends ScriptableObject>
    extends Serializable {
        public boolean apply(U var1, Object var2, Scriptable var3, Scriptable var4, boolean var5);
    }

    public static interface AttributeSetter<U extends ScriptableObject>
    extends Serializable {
        public void apply(U var1, int var2);
    }

    public static interface PropDescriptionSetter<U extends ScriptableObject>
    extends Serializable {
        public boolean apply(U var1, BuiltInSlot<U> var2, Object var3, ScriptableObject.DescriptorInfo var4, boolean var5, Object var6, int var7);
    }

    public static interface Getter<U extends ScriptableObject>
    extends Serializable {
        public Object apply(U var1, Scriptable var2);
    }
}

