/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.micrometer.provider;

import java.util.Optional;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.metrics.micrometer.provider.ExceptionClassProvider;

public class DefaultExceptionClassProvider
implements ExceptionClassProvider {
    @Override
    public Class<?> getExceptionClass(Exchange ex, boolean client) {
        return this.getFault(ex, client).map(Throwable::getCause).map(Object::getClass).orElse(null);
    }

    private Optional<Throwable> getFault(Exchange ex, boolean client) {
        Exception exception = (Exception)ex.get(Exception.class);
        if (client) {
            if (exception == null && ex.getInFaultMessage() != null) {
                exception = (Exception)ex.getInFaultMessage().get(Exception.class);
            }
            if (exception == null && ex.getOutMessage() != null) {
                exception = (Exception)ex.getOutMessage().get(Exception.class);
            }
        } else {
            if (exception == null && ex.getOutFaultMessage() != null) {
                exception = (Exception)ex.getOutFaultMessage().get(Exception.class);
            }
            if (exception == null && ex.getInMessage() != null) {
                exception = (Exception)ex.getInMessage().get(Exception.class);
            }
        }
        return Optional.ofNullable(exception);
    }
}

