/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.DefaultAttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthDecisionStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.Version;

public class SamlCallbackHandler
implements CallbackHandler {
    private TokenProviderParameters tokenParameters;
    private List<AttributeStatementBean> attributeBeans;
    private List<AuthenticationStatementBean> authBeans;
    private List<AuthDecisionStatementBean> authDecisionBeans;
    private ConditionsBean conditionsBean;
    private SubjectBean subjectBean;
    private String issuer;

    public void setAttributeBeans(List<AttributeStatementBean> attributeBeanList) {
        this.attributeBeans = attributeBeanList;
    }

    public void setAuthenticationBeans(List<AuthenticationStatementBean> authBeanList) {
        this.authBeans = authBeanList;
    }

    public void setAuthDecisionStatementBeans(List<AuthDecisionStatementBean> authDecisionBeanList) {
        this.authDecisionBeans = authDecisionBeanList;
    }

    public void setSubjectBean(SubjectBean subjectBean) {
        this.subjectBean = subjectBean;
    }

    public void setConditionsBean(ConditionsBean conditionsBean) {
        this.conditionsBean = conditionsBean;
    }

    public void setTokenProviderParameters(TokenProviderParameters tokenProviderParameters) {
        this.tokenParameters = tokenProviderParameters;
    }

    public void setIssuer(String issuerName) {
        this.issuer = issuerName;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof SAMLCallback)) continue;
            SAMLCallback samlCallback = (SAMLCallback)callback;
            if (this.subjectBean != null) {
                samlCallback.setSubject(this.subjectBean);
            }
            TokenRequirements tokenRequirements = this.tokenParameters.getTokenRequirements();
            String tokenType = tokenRequirements.getTokenType();
            boolean saml1 = false;
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
                samlCallback.setSamlVersion(Version.SAML_11);
                saml1 = true;
                this.setSubjectOnBeans();
            } else {
                samlCallback.setSamlVersion(Version.SAML_20);
            }
            if (this.issuer == null) {
                STSPropertiesMBean stsProperties = this.tokenParameters.getStsProperties();
                samlCallback.setIssuer(stsProperties.getIssuer());
            } else {
                samlCallback.setIssuer(this.issuer);
            }
            boolean statementAdded = false;
            if (this.attributeBeans != null && !this.attributeBeans.isEmpty()) {
                samlCallback.setAttributeStatementData(this.attributeBeans);
                statementAdded = true;
            }
            if (this.authBeans != null && !this.authBeans.isEmpty()) {
                samlCallback.setAuthenticationStatementData(this.authBeans);
                statementAdded = true;
            }
            if (this.authDecisionBeans != null && !this.authDecisionBeans.isEmpty()) {
                samlCallback.setAuthDecisionStatementData(this.authDecisionBeans);
                statementAdded = true;
            }
            if (saml1 && !statementAdded) {
                AttributeStatementBean defaultStatement = new DefaultAttributeStatementProvider().getStatement(this.tokenParameters);
                defaultStatement.setSubject(this.subjectBean);
                samlCallback.setAttributeStatementData(Collections.singletonList(defaultStatement));
            }
            samlCallback.setConditions(this.conditionsBean);
        }
    }

    private void setSubjectOnBeans() {
        if (this.attributeBeans != null) {
            for (AttributeStatementBean attributeBean : this.attributeBeans) {
                if (attributeBean.getSubject() != null) continue;
                attributeBean.setSubject(this.subjectBean);
            }
        }
        if (this.authBeans != null) {
            for (AuthenticationStatementBean authBean : this.authBeans) {
                if (authBean.getSubject() != null) continue;
                authBean.setSubject(this.subjectBean);
            }
        }
        if (this.authDecisionBeans != null) {
            for (AuthDecisionStatementBean authDecisionBean : this.authDecisionBeans) {
                if (authDecisionBean.getSubject() != null) continue;
                authDecisionBean.setSubject(this.subjectBean);
            }
        }
    }
}

