/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageCache;
import org.apache.activemq.artemis.core.paging.impl.PageTimedWriter;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.apache.activemq.artemis.utils.SizeAwareMetric;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingStoreImpl
implements PagingStore {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleString address;
    private final StorageManager storageManager;
    private final DecimalFormat format = new DecimalFormat("000000000");
    private final PageCache usedPages = new PageCache(this);
    private long currentPageSize = 0L;
    private final SimpleString storeName;
    private volatile SequentialFileFactory fileFactory;
    private final PagingStoreFactory storeFactory;
    private PageTimedWriter timedWriter;
    private long maxSize;
    private int maxPageReadBytes = -1;
    private int maxPageReadMessages = -1;
    private int prefetchPageBytes = -1;
    private int prefetchPageMessages = -1;
    private long maxMessages;
    private volatile boolean pageFull;
    private Long pageLimitBytes;
    private Long estimatedMaxPages;
    private Long pageLimitMessages;
    private PageFullMessagePolicy pageFullMessagePolicy;
    private int pageSize;
    private volatile AddressFullMessagePolicy addressFullMessagePolicy;
    private volatile AddressFullMessagePolicy enforcedAddressFullMessagePolicy;
    private boolean printedDropMessagesWarning;
    private final PagingManager pagingManager;
    private final boolean usingGlobalMaxSize;
    private final ArtemisExecutor executor;
    private final SizeAwareMetric size;
    private volatile boolean full;
    private long numberOfPages;
    private long firstPageId;
    private volatile long currentPageId;
    private volatile Page currentPage;
    private volatile boolean paging = false;
    private final PageCursorProvider cursorProvider;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean running = false;
    private final boolean syncNonTransactional;
    private volatile boolean blocking = false;
    private volatile boolean blockedViaAddressControl = false;
    private long rejectThreshold;
    private final Supplier<Boolean> purgePageFolder;
    private final ScheduledExecutorService scheduledExecutorService;
    private final java.util.Queue<Runnable> onMemoryFreedRunnables = new ConcurrentLinkedQueue<Runnable>();

    public PagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, ArtemisExecutor executor, boolean syncNonTransactional) {
        this(address, scheduledExecutor, syncTimeout, pagingManager, storageManager, fileFactory, storeFactory, storeName, addressSettings, executor, syncNonTransactional, () -> false);
    }

    public PagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, ArtemisExecutor executor, boolean syncNonTransactional, Supplier<Boolean> purgePageFolder) {
        Objects.requireNonNull(scheduledExecutor, "scheduledExecutor = null");
        Objects.requireNonNull(pagingManager, "Paging Manager can't be null");
        this.address = address;
        this.storageManager = storageManager;
        this.storeName = storeName;
        this.size = new SizeAwareMetric(this.maxSize, this.maxSize, this.maxMessages, this.maxMessages).setUnderCallback(this::underSized).setOverCallback(this::overSized).setOnSizeCallback(pagingManager::addSize);
        this.applySetting(addressSettings, true);
        this.executor = executor;
        this.pagingManager = pagingManager;
        this.fileFactory = fileFactory;
        this.purgePageFolder = purgePageFolder;
        this.storeFactory = storeFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.timedWriter = this.createPageTimedWriter(scheduledExecutor, syncTimeout);
        this.cursorProvider = storeFactory.newCursorProvider(this, this.storageManager, addressSettings, executor);
        this.usingGlobalMaxSize = pagingManager.isUsingGlobalSize();
        this.scheduledExecutorService = scheduledExecutor;
    }

    protected PageTimedWriter createPageTimedWriter(ScheduledExecutorService scheduledExecutor, long syncTimeout) {
        Objects.requireNonNull(scheduledExecutor, "scheduledExecutor");
        Objects.requireNonNull(this.executor, "executor");
        PageTimedWriter localWriter = new PageTimedWriter(this.pageSize, this.storageManager, this, scheduledExecutor, (Executor)this.executor, this.syncNonTransactional, syncTimeout);
        localWriter.start();
        return localWriter;
    }

    protected void replacePagedTimedWriter(PageTimedWriter writer) {
        this.timedWriter = writer;
    }

    private void overSized() {
        this.full = true;
    }

    private void underSized() {
        this.full = false;
        this.checkReleasedMemory();
    }

    private void configureSizeMetric() {
        this.size.setMax(this.maxSize, this.maxSize, this.maxMessages, this.maxMessages);
    }

    @Override
    public void applySetting(AddressSettings addressSettings) {
        this.applySetting(addressSettings, false);
    }

    private void applySetting(AddressSettings addressSettings, boolean firstTime) {
        this.maxSize = addressSettings.getMaxSizeBytes();
        this.maxPageReadMessages = addressSettings.getMaxReadPageMessages();
        this.prefetchPageMessages = addressSettings.getPrefetchPageMessages();
        this.maxPageReadBytes = addressSettings.getMaxReadPageBytes();
        this.prefetchPageBytes = addressSettings.getPrefetchPageBytes();
        this.maxMessages = addressSettings.getMaxSizeMessages();
        this.configureSizeMetric();
        this.pageSize = this.storageManager.getAllowedPageSize(addressSettings.getPageSizeBytes());
        this.addressFullMessagePolicy = this.enforcedAddressFullMessagePolicy != null ? this.enforcedAddressFullMessagePolicy : addressSettings.getAddressFullMessagePolicy();
        this.rejectThreshold = addressSettings.getMaxSizeBytesRejectThreshold();
        this.pageFullMessagePolicy = addressSettings.getPageFullMessagePolicy();
        this.pageLimitBytes = addressSettings.getPageLimitBytes();
        if (this.pageLimitBytes != null && this.pageLimitBytes < 0L) {
            logger.debug("address {} had pageLimitBytes<0, setting it as null", (Object)this.address);
            this.pageLimitBytes = null;
        }
        Long originalLimitMessages = this.pageLimitMessages;
        this.pageLimitMessages = addressSettings.getPageLimitMessages();
        if (this.pageLimitMessages != null && this.pageLimitMessages < 0L) {
            logger.debug("address {} had pageLimitMessages<0, setting it as null", (Object)this.address);
            this.pageLimitMessages = null;
        }
        if (this.pageLimitBytes == null && this.pageLimitMessages == null && this.pageFullMessagePolicy != null) {
            ActiveMQServerLogger.LOGGER.noPageLimitsSet(this.address, this.pageFullMessagePolicy);
            this.pageFullMessagePolicy = null;
        }
        if (this.pageFullMessagePolicy == null) {
            if (this.pageLimitBytes != null || this.pageLimitMessages != null) {
                ActiveMQServerLogger.LOGGER.noPagefullPolicySet(this.address, this.pageLimitBytes, this.pageLimitMessages);
            }
            this.pageFullMessagePolicy = null;
            this.pageLimitMessages = null;
            this.pageLimitBytes = null;
        }
        boolean pageLimitMessagesChanged = !Objects.equals(this.pageLimitMessages, originalLimitMessages);
        boolean estimatedMaxPagesChanged = false;
        if (this.pageLimitBytes != null && this.pageSize > 0) {
            Long originalEstimatedMaxPages = this.estimatedMaxPages;
            this.estimatedMaxPages = this.pageLimitBytes / (long)this.pageSize;
            logger.debug("Address {} should not allow more than {} pages", (Object)this.storeName, (Object)this.estimatedMaxPages);
            boolean bl = estimatedMaxPagesChanged = !Objects.equals(this.estimatedMaxPages, originalEstimatedMaxPages);
        }
        if (!firstTime && (estimatedMaxPagesChanged || pageLimitMessagesChanged)) {
            if (estimatedMaxPagesChanged) {
                this.checkNumberOfPages();
            }
            this.cursorProvider.checkClearPageLimit();
        }
    }

    public String toString() {
        return "PagingStoreImpl(" + String.valueOf(this.address) + ")";
    }

    @Override
    public PageFullMessagePolicy getPageFullMessagePolicy() {
        return this.pageFullMessagePolicy;
    }

    @Override
    public Long getPageLimitMessages() {
        return this.pageLimitMessages;
    }

    @Override
    public Long getPageLimitBytes() {
        return this.pageLimitBytes;
    }

    @Override
    public void pageFull(PageSubscription subscription) {
        this.pageFull = true;
        try {
            ActiveMQServerLogger.LOGGER.pageFull(subscription.getQueue().getName(), subscription.getQueue().getAddress(), this.pageLimitMessages, subscription.getCounter().getValue());
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    @Override
    public boolean isPageFull() {
        return this.pageFull;
    }

    private boolean isBelowPageLimitBytes() {
        if (this.estimatedMaxPages != null) {
            return this.numberOfPages <= this.estimatedMaxPages;
        }
        return true;
    }

    private void checkNumberOfPages() {
        if (!this.isBelowPageLimitBytes()) {
            this.pageFull = true;
            ActiveMQServerLogger.LOGGER.pageFullMaxBytes(this.storeName, this.numberOfPages, this.estimatedMaxPages, this.pageLimitBytes, this.pageSize);
        }
    }

    @Override
    public void checkPageLimit(long numberOfMessages) {
        boolean pageMessageBytesClear;
        boolean pageMessageMessagesClear = true;
        Long pageLimitMessages = this.getPageLimitMessages();
        if (pageLimitMessages != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Address {} has {} messages on the larger queue", (Object)this.storeName, (Object)numberOfMessages);
            }
            boolean bl = pageMessageMessagesClear = numberOfMessages < pageLimitMessages;
        }
        if ((pageMessageBytesClear = this.isBelowPageLimitBytes()) && pageMessageMessagesClear) {
            this.pageLimitReleased();
        }
    }

    private void pageLimitReleased() {
        if (this.pageFull) {
            ActiveMQServerLogger.LOGGER.pageFree(this.getAddress());
            this.pageFull = false;
        }
    }

    @Override
    public void readLock() {
        this.readLock(-1L);
    }

    @Override
    public boolean readLock(long timeout) {
        try {
            if (timeout == -1L) {
                while (!this.tryReadLock(1L, TimeUnit.SECONDS)) {
                }
                return true;
            }
            return this.tryReadLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean tryReadLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.lock.readLock().tryLock(timeout, unit)) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Not able to read lock");
        }
        return false;
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock(-1L);
    }

    @Override
    public boolean writeLock(long timeout) {
        try {
            if (timeout == -1L) {
                while (!this.tryWriteLock(1L, TimeUnit.SECONDS)) {
                }
                return true;
            }
            return this.tryWriteLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean tryWriteLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.lock.writeLock().tryLock(timeout, unit)) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Not able to write lock");
        }
        return false;
    }

    @Override
    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public PageCursorProvider getCursorProvider() {
        return this.cursorProvider;
    }

    @Override
    public long getFirstPage() {
        return this.firstPageId;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getAddressSize() {
        return this.size.getSize();
    }

    @Override
    public long getAddressElements() {
        return this.size.getElements();
    }

    @Override
    public long getMaxSize() {
        if (this.maxSize <= 0L) {
            return (long)this.pageSize * 2L;
        }
        return this.maxSize;
    }

    @Override
    public int getMaxPageReadBytes() {
        return this.maxPageReadBytes;
    }

    @Override
    public int getPrefetchPageBytes() {
        return this.prefetchPageBytes;
    }

    @Override
    public int getMaxPageReadMessages() {
        return this.maxPageReadMessages;
    }

    @Override
    public int getPrefetchPageMessages() {
        return this.prefetchPageMessages;
    }

    @Override
    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    @Override
    public PagingStoreImpl enforceAddressFullMessagePolicy(AddressFullMessagePolicy enforcedAddressFullMessagePolicy) {
        this.addressFullMessagePolicy = enforcedAddressFullMessagePolicy;
        this.enforcedAddressFullMessagePolicy = enforcedAddressFullMessagePolicy;
        return this;
    }

    @Override
    public int getPageSizeBytes() {
        return this.pageSize;
    }

    @Override
    public File getFolder() {
        SequentialFileFactory factoryUsed = this.fileFactory;
        if (factoryUsed != null) {
            return factoryUsed.getDirectory();
        }
        return null;
    }

    @Override
    public String getFolderName() {
        return this.fileFactory.getDirectoryName();
    }

    @Override
    public boolean isStorePaging() {
        return this.paging;
    }

    @Override
    public boolean isPaging() {
        AddressFullMessagePolicy policy = this.addressFullMessagePolicy;
        if (policy == AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        if (policy == AddressFullMessagePolicy.FAIL) {
            return this.isFull();
        }
        if (policy == AddressFullMessagePolicy.DROP) {
            return this.isFull();
        }
        return this.paging;
    }

    @Override
    public long getNumberOfPages() {
        return this.numberOfPages;
    }

    @Override
    public long getCurrentWritingPage() {
        return this.currentPageId;
    }

    @Override
    public SimpleString getStoreName() {
        return this.storeName;
    }

    @Override
    public void ioSync() throws Exception {
        Page page;
        if (!this.fileFactory.supportsIndividualContext() && (page = this.currentPage) != null) {
            page.trySync();
        }
    }

    @Override
    public void processReload() throws Exception {
        this.cursorProvider.processReload();
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    public boolean isStarted() {
        return this.running;
    }

    @Override
    public void counterSnapshot() {
        this.cursorProvider.counterSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        PagingStoreImpl pagingStoreImpl = this;
        synchronized (pagingStoreImpl) {
            if (this.running) {
                if (this.timedWriter != null) {
                    this.timedWriter.stop();
                }
                if (this.cursorProvider != null) {
                    this.cursorProvider.stop();
                }
            } else {
                return;
            }
            this.running = false;
        }
        ArrayList pendingTasks = new ArrayList();
        Page page = this.currentPage;
        if (page != null) {
            page.close(true);
            this.currentPage = null;
        }
    }

    @Override
    public ArtemisExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void execute(Runnable run) {
        this.executor.execute(run);
    }

    @Override
    public void flushExecutors() {
        FutureLatch future = new FutureLatch();
        try {
            this.executor.execute((Runnable)future);
            if (!future.await(60000L)) {
                ActiveMQServerLogger.LOGGER.pageStoreTimeout(this.address);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumberOfFiles() throws Exception {
        SequentialFileFactory fileFactory = this.fileFactory;
        if (fileFactory != null) {
            List files = fileFactory.listFiles("page");
            return files.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.writeLock();
        try {
            if (this.running) {
                return;
            }
            this.running = true;
            this.firstPageId = Long.MAX_VALUE;
            SequentialFileFactory fileFactory = this.fileFactory;
            if (fileFactory != null) {
                Page page;
                int pageId = 0;
                this.currentPageId = pageId;
                assert (this.currentPage == null);
                this.currentPage = null;
                List files = fileFactory.listFiles("page");
                this.numberOfPages = files.size();
                this.checkNumberOfPages();
                for (String fileName : files) {
                    int fileId = PagingStoreImpl.getPageIdFromFileName(fileName);
                    if (fileId > pageId) {
                        pageId = fileId;
                    }
                    if ((long)fileId >= this.firstPageId) continue;
                    this.firstPageId = fileId;
                }
                this.currentPageId = pageId;
                if (pageId != 0) {
                    this.reloadLivePage(pageId);
                }
                if ((page = this.currentPage) != null && (this.numberOfPages != 1L || page.getSize() != 0L)) {
                    this.startPaging();
                }
                if (this.timedWriter != null) {
                    this.timedWriter.start();
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void reloadLivePage(long pageId) throws Exception {
        Page page = this.newPageObject(pageId);
        page.open(true);
        this.currentPageSize = page.getSize();
        page.getMessages();
        this.resetCurrentPage(page);
        if (page.getSize() != page.getFile().size()) {
            this.openNewPage();
        }
    }

    private void resetCurrentPage(Page newCurrentPage) {
        Page theCurrentPage = this.currentPage;
        if (theCurrentPage != null) {
            theCurrentPage.usageDown();
        }
        if (newCurrentPage != null) {
            newCurrentPage.usageUp();
            this.injectPage(newCurrentPage);
        }
        this.currentPage = newCurrentPage;
    }

    @Override
    public void stopPaging() {
        logger.debug("stopPaging being called, while isPaging={} on {}", (Object)this.paging, (Object)this.storeName);
        this.writeLock();
        try {
            boolean isPaging = this.paging;
            if (isPaging) {
                assert (!this.timedWriter.hasPendingIO()) : "There is pending IO on PagingStoreImpl while calling stopPaging";
                if (this.timedWriter.hasPendingIO()) {
                    logger.debug("There are pending timed writes. Cannot clear paging now.");
                    return;
                }
                this.paging = false;
                ActiveMQServerLogger.LOGGER.pageStoreStop(this.storeName, this.getPageInfo());
                this.pageLimitReleased();
            }
            this.cursorProvider.onPageModeCleared();
            if (this.purgePageFolder.get().booleanValue()) {
                this.execute(this::purgeFolder);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void purgeFolder() {
        this.writeLock();
        try {
            if (!this.isStorePaging() && !this.hasPendingIO() && this.fileFactory != null) {
                ActiveMQServerLogger.LOGGER.purgingPageFolder(this.fileFactory.getDirectoryName(), this.storeName);
                this.usedPages.forEachUsedPage(this::closePage);
                this.usedPages.clear();
                this.closePage(this.currentPage);
                this.currentPage = null;
                this.numberOfPages = 0L;
                if (this.deleteFolder()) {
                    this.cursorProvider.forEachSubscription(PageSubscription::deleteCursorInfo);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void closePage(Page p) {
        try {
            if (p != null) {
                p.close(true);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private String getPageInfo() {
        return String.format("size=%d bytes (%d messages); maxSize=%d bytes (%d messages); globalSize=%d bytes (%d messages); globalMaxSize=%d bytes (%d messages);", this.size.getSize(), this.size.getElements(), this.maxSize, this.maxMessages, this.pagingManager.getGlobalSize(), this.pagingManager.getGlobalMessages(), this.pagingManager.getMaxSize(), this.pagingManager.getMaxMessages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startPaging() {
        if (!this.running) {
            return false;
        }
        this.readLock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.readUnlock();
        }
        try (ArtemisCloseable readLock = this.storageManager.closeableReadLock();){
            block25: {
                this.writeLock();
                try {
                    if (!this.paging) break block25;
                    boolean bl = false;
                    this.writeUnlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.writeUnlock();
                    throw throwable;
                }
            }
            try {
                if (this.currentPage == null) {
                    this.openNewPage();
                } else if (!this.currentPage.getFile().exists() || !this.currentPage.getFile().isOpen()) {
                    this.currentPage.getFile().open();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.pageStoreStartIOError(e);
                this.storageManager.criticalError(e);
                boolean bl = false;
                this.writeUnlock();
                if (readLock != null) {
                    readLock.close();
                }
                return bl;
            }
            this.paging = true;
            ActiveMQServerLogger.LOGGER.pageStoreStart(this.storeName, this.getPageInfo());
            boolean bl = true;
            this.writeUnlock();
            return bl;
        }
    }

    @Override
    public Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean checkPageFileExists(long pageNumber) {
        if (this.fileFactory == null) {
            return false;
        }
        String fileName = this.createFileName(pageNumber);
        SequentialFileFactory factory = null;
        try {
            factory = this.checkFileFactory();
            SequentialFile file = factory.createSequentialFile(fileName);
            return file.exists() && file.size() > 0L;
        }
        catch (Exception ignored) {
            logger.warn("PagingStoreFactory::checkPageFileExists never-throws assumption failed.", (Throwable)ignored);
            return true;
        }
    }

    @Override
    public Page newPageObject(long pageNumber) throws Exception {
        String fileName = this.createFileName(pageNumber);
        SequentialFileFactory factory = this.checkFileFactory();
        SequentialFile file = factory.createSequentialFile(fileName);
        Page page = new Page(this.storeName, this.storageManager, factory, file, pageNumber);
        return page;
    }

    @Override
    public final Page usePage(long pageId) {
        return this.usePage(pageId, true);
    }

    @Override
    public Page usePage(long pageId, boolean create) {
        return this.usePage(pageId, create, create);
    }

    @Override
    public Page usePage(long pageId, boolean createEntry, boolean createFile) {
        if (this.fileFactory == null) {
            return null;
        }
        PageCache pageCache = this.usedPages;
        synchronized (pageCache) {
            try {
                Page page = this.usedPages.get(pageId);
                if (createEntry && page == null) {
                    page = this.newPageObject(pageId);
                    if (page.getFile().exists()) {
                        page.getMessages();
                        this.injectPage(page);
                    } else if (!createFile) {
                        page = null;
                    }
                }
                if (page != null) {
                    page.usageUp();
                }
                return page;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (this.fileFactory != null) {
                    SequentialFile file = this.fileFactory.createSequentialFile(this.createFileName(pageId));
                    this.fileFactory.onIOError((Throwable)e, e.getMessage(), file);
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected SequentialFileFactory getFileFactory() throws Exception {
        this.checkFileFactory();
        return this.fileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteFolder() {
        SequentialFileFactory sequentialFileFactory = this.fileFactory;
        try {
            if (sequentialFileFactory != null) {
                List files;
                try {
                    files = sequentialFileFactory.listFiles(null);
                }
                catch (Exception e) {
                    sequentialFileFactory.onIOError((Throwable)e, e.getMessage());
                    boolean bl = false;
                    this.fileFactory = null;
                    return bl;
                }
                files.forEach(f -> {
                    SequentialFile file = sequentialFileFactory.createSequentialFile(f);
                    try {
                        logger.debug("Deleting {}", (Object)file);
                        file.delete();
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                        sequentialFileFactory.onIOError((Throwable)e, e.getMessage(), file.getFileName());
                    }
                });
                logger.debug("Deleting directory {}", (Object)sequentialFileFactory.getDirectory());
                boolean bl = this.deleteFolder(sequentialFileFactory);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.fileFactory = null;
        }
    }

    private boolean deleteFolder(SequentialFileFactory deletingFolder) {
        if (!deletingFolder.deleteFolder()) {
            ActiveMQServerLogger.LOGGER.failedPurgingFolder(deletingFolder.getDirectory().getAbsolutePath());
            try {
                List filesStillExisting = deletingFolder.listFiles(null);
                filesStillExisting.forEach(f -> logger.info("File {} still on folder {}", f, (Object)deletingFolder.getDirectory().getAbsolutePath()));
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private SequentialFileFactory checkFileFactory() throws Exception {
        SequentialFileFactory factory = this.fileFactory;
        if (factory == null) {
            this.fileFactory = factory = this.storeFactory.newFileFactory(this.getStoreName());
        }
        return factory;
    }

    @Override
    public void forceAnotherPage() throws Exception {
        this.forceAnotherPage(false);
    }

    @Override
    public void forceAnotherPage(boolean useExecutor) throws Exception {
        if (useExecutor) {
            SimpleFutureImpl future = new SimpleFutureImpl();
            this.execute(() -> {
                try {
                    this.openNewPage();
                    future.set((Object)true);
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            });
            future.get();
        } else {
            this.openNewPage();
        }
    }

    @Override
    public Page removePage(int pageId) {
        try {
            if (!this.running) {
                return null;
            }
            if (this.currentPageId == (long)pageId) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring remove({}) as this is the current writing page", (Object)pageId);
                }
                return null;
            }
            Page page = this.usePage(pageId, false);
            if (page == null) {
                page = this.newPageObject(pageId);
            }
            if (page != null && page.getFile().exists()) {
                page.usageDown();
                --this.numberOfPages;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Removing page {}, now containing numberOfPages={}", (Object)pageId, (Object)this.numberOfPages);
            }
            if (this.numberOfPages == 0L && logger.isTraceEnabled()) {
                logger.trace("Page has no pages after removing last page {}", (Object)pageId, (Object)new Exception("Trace"));
            }
            assert (this.numberOfPages >= 0L) : "numberOfPages should never be negative. on removePage(" + pageId + "). numberOfPages=" + this.numberOfPages;
            return page;
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            if (e instanceof AssertionError) {
                AssertionError error = (AssertionError)((Object)e);
                throw error;
            }
            this.storageManager.criticalError(e);
            return null;
        }
    }

    @Override
    public Page depage() throws Exception {
        Page returnPage;
        if (!this.running) {
            return null;
        }
        if (this.numberOfPages == 0L) {
            return null;
        }
        --this.numberOfPages;
        if (this.currentPageId == this.firstPageId) {
            this.firstPageId = Integer.MAX_VALUE;
            logger.trace("Setting up firstPageID=MAX_VALUE");
            if (this.currentPage == null) {
                throw new IllegalStateException("CurrentPage is null");
            }
            returnPage = this.currentPage;
            returnPage.close(true);
            this.resetCurrentPage(null);
            if (returnPage.getNumberOfMessages() == 0 && !this.hasPendingIO()) {
                this.stopPaging();
                returnPage.open(true);
                returnPage.delete(null);
                return null;
            }
            this.openNewPage();
        } else {
            long pageNR;
            Page usedPage;
            if (logger.isTraceEnabled()) {
                logger.trace("firstPageId++ = beforeIncrement={}", (Object)this.firstPageId);
            }
            returnPage = (usedPage = this.usePage(pageNR = this.firstPageId++, false)) == null ? this.newPageObject(pageNR) : usedPage;
        }
        if (!returnPage.getFile().exists()) {
            ++this.numberOfPages;
        }
        assert (this.numberOfPages >= 0L) : "numberOfPages should never be negative. on depage(). currentPageId=" + this.currentPageId + ", firstPageId=" + this.firstPageId;
        return returnPage;
    }

    private void memoryReleased() {
        Runnable runnable;
        while ((runnable = this.onMemoryFreedRunnables.poll()) != null) {
            runnable.run();
        }
    }

    @Override
    public boolean checkMemory(Runnable runWhenAvailable, Consumer<AtomicRunnable> blockedCallback) {
        return this.checkMemory(true, runWhenAvailable, null, blockedCallback);
    }

    private void addToBlockList(AtomicRunnable atomicRunnable, Consumer<AtomicRunnable> accepted) {
        atomicRunnable.setCancel(this.onMemoryFreedRunnables::remove);
        this.onMemoryFreedRunnables.add((Runnable)atomicRunnable);
        if (accepted != null) {
            accepted.accept(atomicRunnable);
        }
    }

    @Override
    public boolean checkMemory(boolean runOnFailure, Runnable runWhenAvailableParameter, Runnable runWhenBlocking, Consumer<AtomicRunnable> blockedCallback) {
        AtomicRunnable runWhenAvailable = AtomicRunnable.checkAtomic((Runnable)runWhenAvailableParameter);
        if (this.blockedViaAddressControl) {
            if (runWhenAvailable != null) {
                this.addToBlockList(runWhenAvailable, blockedCallback);
            }
            return false;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL && (this.maxSize != -1L || this.maxMessages != -1L || this.usingGlobalMaxSize || this.pagingManager.isDiskFull())) {
            if (this.isFull()) {
                if (runOnFailure && runWhenAvailable != null) {
                    this.addToBlockList(runWhenAvailable, blockedCallback);
                    this.pagingManager.addBlockedStore(this);
                }
                return false;
            }
        } else if ((this.pagingManager.isDiskFull() || this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK && (this.maxMessages != -1L || this.maxSize != -1L || this.usingGlobalMaxSize)) && (this.pagingManager.isDiskFull() || this.full || this.pagingManager.isGlobalFull())) {
            if (runWhenBlocking != null) {
                runWhenBlocking.run();
            }
            this.addToBlockList(runWhenAvailable, blockedCallback);
            if (!this.pagingManager.isGlobalFull() && !this.full) {
                runWhenAvailable.run();
                this.onMemoryFreedRunnables.remove(runWhenAvailable);
            } else {
                if (this.usingGlobalMaxSize || this.pagingManager.isDiskFull()) {
                    this.pagingManager.addBlockedStore(this);
                }
                if (!this.blocking) {
                    if (this.pagingManager.isDiskFull()) {
                        ActiveMQServerLogger.LOGGER.blockingDiskFull(this.address);
                    } else {
                        ActiveMQServerLogger.LOGGER.blockingMessageProduction(this.address, this.getPageInfo());
                    }
                    this.blocking = true;
                }
            }
            return true;
        }
        if (runWhenAvailable != null) {
            runWhenAvailable.run();
        }
        return true;
    }

    @Override
    public void addSize(int size, boolean sizeOnly, boolean affectGlobal) {
        long newSize = this.size.addSize(size, sizeOnly, affectGlobal);
        boolean globalFull = this.pagingManager.isGlobalFull();
        if (newSize < 0L) {
            ActiveMQServerLogger.LOGGER.negativeAddressSize(this.address.toString(), newSize);
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            if (this.usingGlobalMaxSize && !globalFull || this.maxSize != -1L) {
                this.checkReleasedMemory();
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE) {
            if (size > 0 && (globalFull || this.full)) {
                this.startPaging();
            }
            return;
        }
    }

    @Override
    public boolean checkReleasedMemory() {
        if (!(this.blockedViaAddressControl || this.pagingManager.isGlobalFull() || this.full)) {
            this.executor.execute(this::memoryReleased);
            if (this.blocking) {
                ActiveMQServerLogger.LOGGER.unblockingMessageProduction(this.address, this.getPageInfo());
                this.blocking = false;
                return true;
            }
        }
        return !this.blocking;
    }

    @Override
    public boolean page(Message message, Transaction tx, RouteContextList listCtx) throws Exception {
        return this.page(message, tx, listCtx, null, false) >= 0;
    }

    @Override
    public int page(Message message, Transaction tx, RouteContextList listCtx, Function<Message, Message> pageDecorator, boolean useFlowControl) throws Exception {
        if (!this.running) {
            return -1;
        }
        boolean full = this.isFull();
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            if (full) {
                if (message.isLargeMessage()) {
                    ((LargeServerMessage)message).deleteFile();
                }
                if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
                    throw ActiveMQMessageBundle.BUNDLE.addressIsFull(this.address.toString());
                }
                if (!this.printedDropMessagesWarning) {
                    this.printedDropMessagesWarning = true;
                    ActiveMQServerLogger.LOGGER.pageStoreDropMessages(this.storeName, this.getPageInfo());
                }
                return 0;
            }
            return -1;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            return -1;
        }
        if (this.pageFull) {
            if (message.isLargeMessage()) {
                ((LargeServerMessage)message).deleteFile();
            }
            if (this.pageFullMessagePolicy == PageFullMessagePolicy.FAIL) {
                throw ActiveMQMessageBundle.BUNDLE.addressIsFull(this.address.toString());
            }
            if (!this.printedDropMessagesWarning) {
                this.printedDropMessagesWarning = true;
                ActiveMQServerLogger.LOGGER.pageStoreDropMessages(this.storeName, this.getPageInfo());
            }
            return 0;
        }
        int creditsUsed = this.writePage(message, tx, listCtx, pageDecorator, useFlowControl);
        return creditsUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePage(Message message, Transaction tx, RouteContextList listCtx, Function<Message, Message> pageDecorator, boolean useFlowControl) throws Exception {
        PagedMessageImpl pagedMessage;
        this.readLock();
        try {
            long persistentSize;
            long transactionID;
            if (!this.paging) {
                int n = -1;
                return n;
            }
            long l = transactionID = tx != null && tx.isAllowPageTransaction() ? tx.getID() : -1L;
            if (pageDecorator != null) {
                message = pageDecorator.apply(message);
            }
            message.setPaged();
            pagedMessage = new PagedMessageImpl(message, this.routeQueues(tx, listCtx), transactionID);
            long l2 = persistentSize = pagedMessage.getPersistentSize() > 0L ? pagedMessage.getPersistentSize() : 0L;
            if (tx != null && tx.isAllowPageTransaction()) {
                this.installPageTransaction(tx, listCtx);
            }
            this.timedWriter.incrementTask();
            this.applyPageCounters(tx, listCtx, persistentSize);
        }
        finally {
            this.readUnlock();
        }
        int credits = this.timedWriter.addTask(this.storageManager.getContext(), pagedMessage, tx, listCtx, useFlowControl);
        assert (credits >= 0);
        return credits;
    }

    @Override
    public void writeFlowControl(int credits) {
        if (this.timedWriter != null) {
            this.timedWriter.flowControl(credits);
        }
    }

    protected void directWritePage(PagedMessage pagedMessage, boolean lineUp, boolean originalReplicated) throws Exception {
        Page page;
        int bytesToWrite = pagedMessage.getEncodeSize() + 6;
        this.currentPageSize += (long)bytesToWrite;
        if (this.currentPage == null || this.currentPageSize > (long)this.pageSize && this.currentPage.getNumberOfMessages() > 0) {
            this.openNewPage();
            this.currentPageSize += (long)bytesToWrite;
        }
        if (!(page = this.currentPage).isOpen()) {
            page.open(false);
        }
        page.write(pagedMessage, lineUp, originalReplicated);
        if (logger.isTraceEnabled()) {
            logger.trace("Paging message {} on pageStore {} pageNr={}", new Object[]{pagedMessage, this.getStoreName(), page.getPageId()});
        }
    }

    @Override
    public void disableCleanup() {
        this.getCursorProvider().disableCleanup();
    }

    @Override
    public void enableCleanup() {
        this.getCursorProvider().resumeCleanup();
    }

    private long[] routeQueues(Transaction tx, RouteContextList ctx) throws Exception {
        List<Queue> durableQueues = ctx.getDurableQueues();
        List<Queue> nonDurableQueues = ctx.getNonDurableQueues();
        long[] ids = new long[durableQueues.size() + nonDurableQueues.size()];
        int i = 0;
        for (Queue q : durableQueues) {
            q.getPageSubscription().notEmpty();
            ids[i++] = q.getID();
        }
        for (Queue q : nonDurableQueues) {
            q.getPageSubscription().notEmpty();
            ids[i++] = q.getID();
        }
        return ids;
    }

    private void applyPageCounters(Transaction tx, RouteContextList ctx, long size) throws Exception {
        List<Queue> durableQueues = ctx.getDurableQueues();
        List<Queue> nonDurableQueues = ctx.getNonDurableQueues();
        for (Queue q : durableQueues) {
            q.getPageSubscription().getCounter().increment(tx, 1, size);
        }
        for (Queue q : nonDurableQueues) {
            q.getPageSubscription().getCounter().increment(tx, 1, size);
        }
    }

    public void durableDown(Message message, int durableCount) {
        this.refDown(message, durableCount);
    }

    public void durableUp(Message message, int durableCount) {
        this.refUp(message, durableCount);
    }

    public void refUp(Message message, int count) {
        this.addSize(MessageReferenceImpl.getMemoryEstimate(), true);
    }

    public void refDown(Message message, int count) {
        if (count < 0) {
            return;
        }
        this.addSize(-MessageReferenceImpl.getMemoryEstimate(), true);
    }

    private void installPageTransaction(Transaction tx, RouteContextList listCtx) throws Exception {
        FinishPageMessageOperation pgOper = (FinishPageMessageOperation)tx.getProperty(5);
        if (pgOper == null) {
            PageTransactionInfoImpl pgTX = new PageTransactionInfoImpl(tx.getID());
            this.pagingManager.addTransaction(pgTX);
            pgOper = new FinishPageMessageOperation(pgTX, this.storageManager, this.pagingManager);
            tx.putProperty(5, pgOper);
            tx.addOperation(pgOper);
        }
        if (!tx.isAsync()) {
            pgOper.addStore(this);
        }
        pgOper.pageTransaction.increment(listCtx.getNumberOfDurableQueues(), listCtx.getNumberOfNonDurableQueues());
    }

    @Override
    public boolean hasPendingIO() {
        return this.timedWriter.hasPendingIO();
    }

    public PageTimedWriter getPageTimedWriter() {
        return this.timedWriter;
    }

    @Override
    public void destroy() throws Exception {
        this.timedWriter.stop();
        this.execute(this::internalDestroy);
        OperationContext context = OperationContextImpl.getContext();
        if (context != null) {
            context.storeLineUp();
            this.execute(() -> ((OperationContext)context).done());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDestroy() {
        try (ArtemisCloseable readLock = this.storageManager.closeableReadLock();){
            this.writeLock();
            try {
                SequentialFileFactory factory = this.fileFactory;
                if (factory != null) {
                    try {
                        this.storeFactory.removeFileFactory(factory);
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                this.writeUnlock();
                try {
                    this.stop();
                }
                catch (Exception e2) {
                    logger.debug(e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    private void openNewPage() throws Exception {
        Page oldPage;
        ++this.numberOfPages;
        this.checkNumberOfPages();
        long newPageId = this.currentPageId + 1L;
        if (logger.isTraceEnabled()) {
            logger.trace("destination {} new pageNr={}", (Object)this.storeName, (Object)newPageId);
        }
        if ((oldPage = this.currentPage) != null) {
            oldPage.close(true);
            oldPage.usageDown();
            this.currentPage = null;
        }
        Page newPage = this.newPageObject(newPageId);
        this.resetCurrentPage(newPage);
        this.currentPageSize = 0L;
        newPage.open(true);
        this.currentPageId = newPageId;
        if (newPageId < this.firstPageId) {
            logger.debug("open new page, setting firstPageId = {}, it was {} before", (Object)newPageId, (Object)this.firstPageId);
            this.firstPageId = newPageId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFileName(long pageID) {
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            return this.format.format(pageID) + ".page";
        }
    }

    private static int getPageIdFromFileName(String fileName) {
        return Integer.parseInt(fileName.substring(0, fileName.indexOf(46)));
    }

    @Override
    public boolean isFull() {
        return this.full || this.pagingManager.isGlobalFull();
    }

    @Override
    public int getAddressLimitPercent() {
        long currentUsage = this.getAddressSize();
        if (this.maxSize > 0L) {
            return (int)(currentUsage * 100L / this.maxSize);
        }
        if (this.pagingManager.isUsingGlobalSize()) {
            return (int)(currentUsage * 100L / this.pagingManager.getMaxSize());
        }
        return 0;
    }

    @Override
    public void block() {
        if (!this.blockedViaAddressControl) {
            ActiveMQServerLogger.LOGGER.blockingViaControl(this.address);
        }
        this.blockedViaAddressControl = true;
    }

    @Override
    public void unblock() {
        if (this.blockedViaAddressControl) {
            ActiveMQServerLogger.LOGGER.unblockingViaControl(this.address);
        }
        this.blockedViaAddressControl = false;
        this.checkReleasedMemory();
    }

    @Override
    public boolean isRejectingMessages() {
        if (this.addressFullMessagePolicy != AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        return this.rejectThreshold != -1L && this.getAddressSize() > this.rejectThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getCurrentIds() throws Exception {
        this.readLock();
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            SequentialFileFactory factory = this.fileFactory;
            if (factory != null) {
                for (String fileName : factory.listFiles("page")) {
                    ids.add(PagingStoreImpl.getPageIdFromFileName(fileName));
                }
            }
            ArrayList<Integer> arrayList = ids;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void sendPages(ReplicationManager replicator, Collection<Integer> pageIds) throws Exception {
        SequentialFileFactory factory = this.fileFactory;
        for (Integer id : pageIds) {
            SequentialFile sFile = factory.createSequentialFile(this.createFileName(id.intValue()));
            if (!sFile.exists()) continue;
            ActiveMQServerLogger.LOGGER.replicaSyncFile(sFile, sFile.size());
            replicator.syncPages(sFile, id.intValue(), this.getAddress());
        }
    }

    private void injectPage(Page page) {
        this.usedPages.injectPage(page);
    }

    protected int getUsedPagesSize() {
        return this.usedPages.size();
    }

    protected void forEachUsedPage(Consumer<Page> consumerPage) {
        this.usedPages.forEachUsedPage(consumerPage);
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    private static class FinishPageMessageOperation
    implements TransactionOperation {
        private final PageTransactionInfo pageTransaction;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;
        private final Set<PagingStore> usedStores = new HashSet<PagingStore>();
        private boolean stored = false;

        public void addStore(PagingStore store) {
            this.usedStores.add(store);
        }

        private FinishPageMessageOperation(PageTransactionInfo pageTransaction, StorageManager storageManager, PagingManager pagingManager) {
            this.pageTransaction = pageTransaction;
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        @Override
        public void afterCommit(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.commit();
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.rollback();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.storePageTX(tx);
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.storePageTX(tx);
        }

        private void storePageTX(Transaction tx) throws Exception {
            if (!this.stored) {
                tx.setContainsPersistent();
                this.pageTransaction.store(this.storageManager, this.pagingManager, tx);
                this.stored = true;
            }
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }
}

