/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.servlet.jackrabbit.JackrabbitRepositoryServlet;
import org.apache.jackrabbit.standalone.Main;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.JcrClient;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class JackrabbitMain {
    private final Options options = new Options();
    private final CommandLine command;
    private final RequestLogHandler accessLog = new RequestLogHandler();
    private final WebAppContext webapp = new WebAppContext();
    private final Server server = new Server();
    private final ServerConnector connector = new ServerConnector(this.server);

    public static void main(String[] args) throws Exception {
        new JackrabbitMain(args).run();
    }

    protected JackrabbitMain(String[] args) throws ParseException {
        this.options.addOption("?", "help", false, "print this message");
        this.options.addOption("n", "notice", false, "print copyright notices");
        this.options.addOption("l", "license", false, "print license information");
        this.options.addOption("b", "backup", false, "create a backup of the repository");
        this.options.addOption("i", "cli", true, "command line access to a remote repository");
        this.options.addOption("q", "quiet", false, "disable console output");
        this.options.addOption("d", "debug", false, "enable debug logging");
        this.options.addOption("h", "host", true, "IP address of the HTTP server");
        this.options.addOption("p", "port", true, "TCP port of the HTTP server (8080)");
        this.options.addOption("f", "file", true, "location of this jar file");
        this.options.addOption("r", "repo", true, "repository directory (jackrabbit)");
        this.options.addOption("c", "conf", true, "repository configuration file");
        this.options.addOption("R", "backup-repo", true, "backup repository directory (jackrabbit-backupN)");
        this.options.addOption("C", "backup-conf", true, "backup repository configuration file");
        this.command = new DefaultParser().parse(this.options, args);
    }

    private void backup(File sourceDir) throws Exception {
        File targetDir;
        RepositoryConfig source = this.command.hasOption("conf") ? RepositoryConfig.create((File)new File(this.command.getOptionValue("conf")), (File)sourceDir) : RepositoryConfig.create((File)sourceDir);
        if (this.command.hasOption("backup-repo")) {
            targetDir = new File(this.command.getOptionValue("backup-repo"));
        } else {
            int i = 1;
            while ((targetDir = new File("jackrabbit-backup" + i++)).exists()) {
            }
        }
        RepositoryConfig target = this.command.hasOption("backup-conf") ? RepositoryConfig.install((File)new File(this.command.getOptionValue("backup-conf")), (File)targetDir) : RepositoryConfig.install((File)targetDir);
        this.message("Creating a repository copy in " + targetDir);
        RepositoryCopier.copy((RepositoryConfig)source, (RepositoryConfig)target);
        this.message("The repository has been successfully copied.");
    }

    private void copyToOutput(String resource) throws IOException {
        try (InputStream stream = JackrabbitMain.class.getResourceAsStream(resource);){
            IOUtils.copy((InputStream)stream, (OutputStream)System.out);
        }
    }

    private void message(String message) {
        if (!this.command.hasOption("quiet")) {
            System.out.println(message);
        }
    }

    private void prepareAccessLog(File log) {
        NCSARequestLog ncsa = new NCSARequestLog(new File(log, "access.log.yyyy_mm_dd").getPath());
        ncsa.setFilenameDateFormat("yyyy-MM-dd");
        this.accessLog.setRequestLog((RequestLog)ncsa);
    }

    private void prepareConnector() {
        String port = this.command.getOptionValue("port", "8080");
        this.connector.setPort(Integer.parseInt(port));
        String host = this.command.getOptionValue("host");
        if (host != null) {
            this.connector.setHost(host);
        }
    }

    private void prepareServerLog(File log) throws IOException {
        System.setProperty("jackrabbit.log", new File(log, "jackrabbit.log").getPath());
        System.setProperty("jetty.log", new File(log, "jetty.log").getPath());
        if (this.command.hasOption("debug")) {
            System.setProperty("log.level", "DEBUG");
        } else {
            System.setProperty("log.level", "INFO");
        }
        System.setProperty("derby.stream.error.file", new File(log, "derby.log").getPath());
    }

    private void prepareShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JackrabbitMain.this.shutdown();
            }
        });
    }

    private void prepareWebapp(File file, File repository, File tmp) {
        this.webapp.setContextPath("/");
        this.webapp.setWar(file.getPath());
        this.webapp.setExtractWAR(true);
        this.webapp.setTempDirectory(tmp);
        ServletHolder servlet = new ServletHolder(JackrabbitRepositoryServlet.class);
        servlet.setInitOrder(1);
        servlet.setInitParameter("repository.home", repository.getPath());
        String conf = this.command.getOptionValue("conf");
        if (conf != null) {
            servlet.setInitParameter("repository.config", conf);
        }
        this.webapp.addServlet(servlet, "/repository.properties");
    }

    public void run() throws Exception {
        File file;
        String defaultFile = "jackrabbit-standalone.jar";
        URL location = Main.class.getProtectionDomain().getCodeSource().getLocation();
        if (location != null && "file".equals(location.getProtocol()) && (file = new File(location.getPath())).isFile()) {
            defaultFile = location.getPath();
        }
        file = new File(this.command.getOptionValue("file", defaultFile));
        if (this.command.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar " + file.getName(), this.options, true);
        } else if (this.command.hasOption("notice")) {
            this.copyToOutput("/META-INF/NOTICE.txt");
        } else if (this.command.hasOption("license")) {
            this.copyToOutput("/META-INF/LICENSE.txt");
        } else if (this.command.hasOption("cli")) {
            System.setProperty("logback.configurationFile", "logback-cli.xml");
            String uri = this.command.getOptionValue("cli");
            Repository repository = JcrUtils.getRepository((String)uri);
            ContextBase context = new ContextBase();
            CommandHelper.setRepository((Context)context, (Repository)repository, (String)uri);
            try {
                Session session = repository.login();
                CommandHelper.setSession((Context)context, (Session)session);
                CommandHelper.setCurrentNode((Context)context, (Node)session.getRootNode());
            }
            catch (RepositoryException session) {
                // empty catch block
            }
            new JcrClient((Context)context).runInteractive();
            try {
                CommandHelper.getSession((Context)context).logout();
            }
            catch (CommandException session) {}
        } else {
            this.message("Welcome to Apache Jackrabbit!");
            this.message("-------------------------------");
            File repository = new File(this.command.getOptionValue("repo", "jackrabbit"));
            this.message("Using repository directory " + repository);
            repository.mkdirs();
            File tmp = new File(repository, "tmp");
            tmp.mkdir();
            File log = new File(repository, "log");
            log.mkdir();
            this.message("Writing log messages to " + log);
            this.prepareServerLog(log);
            if (this.command.hasOption("backup")) {
                this.backup(repository);
            } else {
                this.message("Starting the server...");
                this.prepareWebapp(file, repository, tmp);
                this.accessLog.setHandler((Handler)this.webapp);
                this.prepareAccessLog(log);
                this.server.setHandler((Handler)this.accessLog);
                this.prepareConnector();
                this.server.addConnector((Connector)this.connector);
                this.prepareShutdown();
                try {
                    this.server.start();
                    String host = this.connector.getHost();
                    if (host == null) {
                        host = "localhost";
                    }
                    this.message("Apache Jackrabbit is now running at http://" + host + ":" + this.connector.getPort() + "/");
                }
                catch (Throwable t) {
                    System.err.println("Unable to start the server: " + t.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    public void shutdown() {
        try {
            this.message("Shutting down the server...");
            this.server.stop();
            this.server.join();
            this.message("-------------------------------");
            this.message("Goodbye from Apache Jackrabbit!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

