/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.apache.commons.numbers.core.DD;
import org.apache.commons.numbers.core.ExtendedPrecision;

public final class Sum
implements DoubleSupplier,
DoubleConsumer {
    private double sum;
    private double comp;

    private Sum(double initialValue) {
        this.sum = initialValue;
    }

    public Sum add(double t) {
        double newSum = this.sum + t;
        this.comp += DD.twoSumLow(this.sum, t, newSum);
        this.sum = newSum;
        return this;
    }

    public Sum add(double ... terms) {
        for (double t : terms) {
            this.add(t);
        }
        return this;
    }

    public Sum addProduct(double a, double b) {
        double ab = a * b;
        double pLow = ExtendedPrecision.productLow(a, b, ab);
        double newSum = this.sum + ab;
        this.comp += DD.twoSumLow(this.sum, ab, newSum) + pLow;
        this.sum = newSum;
        return this;
    }

    public Sum addProducts(double[] a, double[] b) {
        int len = a.length;
        if (len != b.length) {
            throw new IllegalArgumentException("Dimension mismatch: " + a.length + " != " + b.length);
        }
        for (int i = 0; i < len; ++i) {
            this.addProduct(a[i], b[i]);
        }
        return this;
    }

    public Sum add(Sum other) {
        return this.add(other.sum, other.comp);
    }

    public Sum subtract(Sum other) {
        return this.add(-other.sum, -other.comp);
    }

    private Sum add(double s, double c) {
        DD result = DD.ofSum(this.sum, this.comp).add(DD.ofSum(s, c));
        if (result.isFinite()) {
            this.sum = result.hi();
            this.comp = result.lo();
        } else {
            this.add(s);
            if (!Double.isNaN(c)) {
                this.add(c);
            }
        }
        return this;
    }

    @Override
    public void accept(double value) {
        this.add(value);
    }

    @Override
    public double getAsDouble() {
        double hpsum = this.sum + this.comp;
        return Double.isFinite(hpsum) ? hpsum : this.sum;
    }

    public static Sum create() {
        return new Sum(0.0);
    }

    public static Sum of(double a) {
        return new Sum(a);
    }

    public static Sum of(double ... values) {
        return Sum.create().add(values);
    }

    public static Sum ofProducts(double[] a, double[] b) {
        return Sum.create().addProducts(a, b);
    }
}

