/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.icns;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.AbstractBinaryOutputStream;
import org.apache.commons.imaging.common.BigEndianBinaryOutputStream;
import org.apache.commons.imaging.formats.icns.AbstractIcnsTest;
import org.apache.commons.imaging.formats.icns.IcnsImageParser;
import org.apache.commons.imaging.formats.icns.IcnsType;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IcnsRoundTripTest
extends AbstractIcnsTest {
    private static final int[][] IMAGE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    @Test
    public void test1BPPIconMaskVersus8BPPMask() throws Exception {
        int foreground = -16777216;
        int background = -16777216;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            int y;
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(344);
            bos.write4Bytes(IcnsType.ICNS_16x16_1BIT_IMAGE_AND_MASK.getType());
            bos.write4Bytes(72);
            for (y = 0; y < 16; ++y) {
                bos.write(255);
                bos.write(255);
            }
            for (y = 0; y < 16; ++y) {
                bos.write(255);
                bos.write(255);
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_MASK.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(0);
                }
            }
            bos.flush();
            this.writeAndReadImageData("1bpp-image-mask-versus-8bpp-mask", baos.toByteArray(), -16777216, -16777216);
        }
    }

    @Test
    public void test32BPPHalfMaskedIcon() throws Exception {
        int foreground = -16777216;
        int background = -16776961;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            int x;
            int y;
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(1080);
            bos.write4Bytes(IcnsType.ICNS_16x16_32BIT_IMAGE.getType());
            bos.write4Bytes(1032);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    bos.write(0);
                    int pixel = IMAGE[y][x] != 0 ? -16777216 : -16776961;
                    bos.write(0xFF & pixel >> 16);
                    bos.write(0xFF & pixel >> 8);
                    bos.write(0xFF & pixel);
                }
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_1BIT_IMAGE_AND_MASK.getType());
            bos.write4Bytes(40);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; x += 8) {
                    int eightBits = 0;
                    for (int pos = 0; pos < 8; ++pos) {
                        if (IMAGE[y][x + pos] == 0) continue;
                        eightBits |= 1 << 7 - pos;
                    }
                    bos.write(eightBits);
                }
            }
            bos.flush();
            Assertions.assertThrows(ImagingException.class, () -> this.writeAndReadImageData("32bpp-half-masked-CORRUPT", baos.toByteArray(), -16777216, -16776961));
        }
    }

    @Test
    public void test32BPPMaskedIcon() throws Exception {
        int foreground = -16777216;
        int background = 255;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            int pos;
            int eightBits;
            int x;
            int y;
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(1112);
            bos.write4Bytes(IcnsType.ICNS_16x16_32BIT_IMAGE.getType());
            bos.write4Bytes(1032);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    bos.write(0);
                    int pixel = IMAGE[y][x] != 0 ? -16777216 : 255;
                    bos.write(0xFF & pixel >> 16);
                    bos.write(0xFF & pixel >> 8);
                    bos.write(0xFF & pixel);
                }
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_1BIT_IMAGE_AND_MASK.getType());
            bos.write4Bytes(72);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; x += 8) {
                    eightBits = 0;
                    for (pos = 0; pos < 8; ++pos) {
                        if (IMAGE[y][x + pos] == 0) continue;
                        eightBits |= 1 << 7 - pos;
                    }
                    bos.write(eightBits);
                }
            }
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; x += 8) {
                    eightBits = 0;
                    for (pos = 0; pos < 8; ++pos) {
                        if (IMAGE[y][x + pos] == 0) continue;
                        eightBits |= 1 << 7 - pos;
                    }
                    bos.write(eightBits);
                }
            }
            bos.flush();
            this.writeAndReadImageData("32bpp-image-1bpp-mask", baos.toByteArray(), -16777216, 255);
        }
    }

    @Test
    public void test32BPPMaskMissingIcon() throws Exception {
        int foreground = -16777216;
        int background = -16776961;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(1040);
            bos.write4Bytes(IcnsType.ICNS_16x16_32BIT_IMAGE.getType());
            bos.write4Bytes(1032);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    bos.write(0);
                    int pixel = IMAGE[y][x] != 0 ? -16777216 : -16776961;
                    bos.write(0xFF & pixel >> 16);
                    bos.write(0xFF & pixel >> 8);
                    bos.write(0xFF & pixel);
                }
            }
            bos.flush();
            this.writeAndReadImageData("32bpp-mask-missing", baos.toByteArray(), -16777216, -16776961);
        }
    }

    @Test
    public void test8BPPIcon1BPPMaskVersus8BPPMask() throws Exception {
        int foreground = -16777216;
        int background = 0xCCCCCC;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            int x;
            int y;
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(608);
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_IMAGE.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(43);
                }
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_1BIT_IMAGE_AND_MASK.getType());
            bos.write4Bytes(72);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; x += 8) {
                    int eightBits = 0;
                    for (int pos = 0; pos < 8; ++pos) {
                        if (IMAGE[y][x + pos] == 0) continue;
                        eightBits |= 1 << 7 - pos;
                    }
                    bos.write(eightBits);
                }
            }
            for (y = 0; y < 16; ++y) {
                bos.write(255);
                bos.write(255);
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_MASK.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(0);
                }
            }
            bos.flush();
            this.writeAndReadImageData("8bpp-image-1bpp-mask-vs-8bpp-mask", baos.toByteArray(), -16777216, 0xCCCCCC);
        }
    }

    @Test
    public void test8BPPIcon8BPPMask() throws Exception {
        int foreground = -16777216;
        int background = 0xCCCCCC;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            int x;
            int y;
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(536);
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_IMAGE.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(43);
                }
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_MASK.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(0);
                }
            }
            bos.flush();
            this.writeAndReadImageData("8bpp-image-8bpp-mask", baos.toByteArray(), -16777216, 0xCCCCCC);
        }
    }

    @Test
    public void test8BPPIcon8BPPMaskVersus1BPPMask() throws Exception {
        int foreground = -16777216;
        int background = 0xCCCCCC;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            int x;
            int y;
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(608);
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_IMAGE.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(43);
                }
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_MASK.getType());
            bos.write4Bytes(264);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(0);
                }
            }
            bos.write4Bytes(IcnsType.ICNS_16x16_1BIT_IMAGE_AND_MASK.getType());
            bos.write4Bytes(72);
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; x += 8) {
                    int eightBits = 0;
                    for (int pos = 0; pos < 8; ++pos) {
                        if (IMAGE[y][x + pos] == 0) continue;
                        eightBits |= 1 << 7 - pos;
                    }
                    bos.write(eightBits);
                }
            }
            for (y = 0; y < 16; ++y) {
                bos.write(255);
                bos.write(255);
            }
            bos.flush();
            this.writeAndReadImageData("8bpp-image-8bpp-mask-vs-1bpp-mask", baos.toByteArray(), -16777216, 0xCCCCCC);
        }
    }

    @Test
    public void test8BPPIconNoMask() throws Exception {
        int foreground = -16777216;
        int background = -3355444;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BigEndianBinaryOutputStream bos = AbstractBinaryOutputStream.bigEndian((OutputStream)baos);){
            bos.write4Bytes(IcnsImageParser.ICNS_MAGIC);
            bos.write4Bytes(272);
            bos.write4Bytes(IcnsType.ICNS_16x16_8BIT_IMAGE.getType());
            bos.write4Bytes(264);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (IMAGE[y][x] != 0) {
                        bos.write(255);
                        continue;
                    }
                    bos.write(43);
                }
            }
            bos.flush();
            this.writeAndReadImageData("8bpp-image-no-mask", baos.toByteArray(), -16777216, -3355444);
        }
    }

    private void verify(BufferedImage data, int foreground, int background) {
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)data.getHeight(), (int)IMAGE.length);
        for (int y = 0; y < data.getHeight(); ++y) {
            Assertions.assertEquals((int)data.getWidth(), (int)IMAGE[y].length);
            for (int x = 0; x < data.getWidth(); ++x) {
                int dataARGB;
                int imageARGB = IMAGE[y][x] == 1 ? foreground : background;
                if (imageARGB != (dataARGB = data.getRGB(x, y))) {
                    Debug.debug((String)("x: " + x + ", y: " + y + ", image: " + imageARGB + " (0x" + Integer.toHexString(imageARGB) + "), data: " + dataARGB + " (0x" + Integer.toHexString(dataARGB) + ")"));
                }
                Assertions.assertEquals((int)imageARGB, (int)dataARGB);
            }
        }
    }

    private void writeAndReadImageData(String description, byte[] rawData, int foreground, int background) throws IOException, ImagingException {
        BufferedImage dstImage = Imaging.getBufferedImage((InputStream)new ByteArrayInputStream(rawData), (String)"description.icns");
        Assertions.assertNotNull((Object)dstImage);
        Assertions.assertEquals((int)dstImage.getWidth(), (int)IMAGE[0].length);
        Assertions.assertEquals((int)dstImage.getHeight(), (int)IMAGE.length);
        this.verify(dstImage, foreground, background);
    }
}

