/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.DateType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.JsonType;
import org.apache.cayenne.access.types.TimeType;
import org.apache.cayenne.access.types.TimestampType;
import org.apache.cayenne.access.types.UtilDateType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.DefaultQuotingStrategy;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.mysql.MySQLActionBuilder;
import org.apache.cayenne.dba.mysql.MySQLEJBQLTranslatorFactory;
import org.apache.cayenne.dba.mysql.MySQLPkGenerator;
import org.apache.cayenne.dba.mysql.MySQLTreeProcessor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class MySQLAdapter
extends JdbcAdapter {
    static final String DEFAULT_STORAGE_ENGINE = "InnoDB";
    static final List<String> SYSTEM_CATALOGS = Arrays.asList("sys", "information_schema", "mysql", "performance_schema");
    protected String storageEngine = "InnoDB";

    public MySQLAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    protected QuotingStrategy createQuotingStrategy() {
        return new DefaultQuotingStrategy("`", "`");
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return MySQLTreeProcessor.getInstance(this.caseInsensitiveCollations);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new MySQLActionBuilder(node));
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        StringBuilder buf = new StringBuilder();
        QuotingStrategy context = this.getQuotingStrategy();
        buf.append(context.quotedFullyQualifiedName(table));
        return Arrays.asList("SET FOREIGN_KEY_CHECKS=0", "DROP TABLE IF EXISTS " + buf.toString() + " CASCADE", "SET FOREIGN_KEY_CHECKS=1");
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        CharType charType = new CharType(false, false);
        map.registerType(charType);
        map.registerType(new ByteArrayType(false, false));
        map.registerType(new JsonType(charType, true));
        map.registerType(new DateType(true));
        map.registerType(new TimeType(true));
        map.registerType(new TimestampType(true));
        map.registerType(new UtilDateType(true));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (typeName != null) {
            typeName = typeName.toLowerCase();
        }
        if (type == 1111) {
            if ("longblob".equals(typeName)) {
                type = 2004;
            } else if ("mediumblob".equals(typeName)) {
                type = 2004;
            } else if ("blob".equals(typeName)) {
                type = 2004;
            } else if ("tinyblob".equals(typeName)) {
                type = -3;
            } else if ("longtext".equals(typeName)) {
                type = 2005;
            } else if ("mediumtext".equals(typeName)) {
                type = 2005;
            } else if ("text".equals(typeName)) {
                type = 2005;
            } else if ("tinytext".equals(typeName)) {
                type = 12;
            }
        } else if (typeName != null && typeName.endsWith(" unsigned") && ("int unsigned".equals(typeName) || "integer unsigned".equals(typeName) || "mediumint unsigned".equals(typeName))) {
            type = -5;
        }
        if (type == 1 && "json".equals(typeName)) {
            type = -1;
        }
        if (type == 92) {
            precision = Math.max(0, size - 9);
            size = -1;
        } else if (type == 93) {
            precision = Math.max(0, size - 20);
            size = -1;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws SQLException, Exception {
        binding.setJdbcType(this.mapNTypes(binding.getJdbcType()));
        super.bindParameter(statement, binding);
    }

    private int mapNTypes(int sqlType) {
        switch (sqlType) {
            case -15: {
                return 1;
            }
            case 2011: {
                return 2005;
            }
            case -9: {
                return 12;
            }
            case -16: {
                return -1;
            }
        }
        return sqlType;
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new MySQLPkGenerator(this);
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        MySQLEJBQLTranslatorFactory translatorFactory = new MySQLEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public String createTable(DbEntity entity) {
        String ddlSQL = super.createTable(entity);
        if (this.storageEngine != null) {
            ddlSQL = ddlSQL + " ENGINE=" + this.storageEngine;
        }
        return ddlSQL;
    }

    @Override
    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        ArrayList<DbAttribute> pkList = new ArrayList<DbAttribute>(entity.getPrimaryKeys());
        pkList.sort(PKComparator.INSTANCE);
        Iterator pkit = pkList.iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                sqlBuffer.append(this.quotingStrategy.quotedName(at));
            }
            sqlBuffer.append(')');
        }
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String type = MySQLAdapter.getType(this, column);
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ').append(type);
        this.appendLengthAndScale(sqlBuffer, column);
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : " NULL");
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    private void appendLengthAndScale(StringBuffer sqlBuffer, DbAttribute column) {
        if (column.getType() == 92 || column.getType() == 93) {
            int scale = column.getScale();
            if (scale >= 0) {
                sqlBuffer.append('(').append(scale).append(')');
            }
        } else if (this.typeSupportsLength(column.getType())) {
            int scale;
            int len = column.getMaxLength();
            int n = scale = TypesMapping.isDecimal(column.getType()) ? column.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
    }

    @Override
    public boolean typeSupportsLength(int type) {
        switch (type) {
            case 92: 
            case 93: {
                return true;
            }
        }
        return super.typeSupportsLength(type);
    }

    @Override
    public List<String> getSystemCatalogs() {
        return SYSTEM_CATALOGS;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public void setStorageEngine(String engine) {
        this.storageEngine = engine;
    }

    static final class PKComparator
    implements Comparator<DbAttribute> {
        static final PKComparator INSTANCE = new PKComparator();

        PKComparator() {
        }

        @Override
        public int compare(DbAttribute a1, DbAttribute a2) {
            if (a1.isGenerated() != a2.isGenerated()) {
                return a1.isGenerated() ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

