/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.PrimitiveAssertion;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.HttpsToken;
import org.apache.ws.secpolicy.model.TransportToken;

public class TransportTokenBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        TransportToken transportToken = new TransportToken(1);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        Iterator iterator = (policy = policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), transportToken);
        }
        return transportToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.TRANSPORT_TOKEN};
    }

    private void processAlternative(List<Assertion> assertions, TransportToken parent) {
        for (Assertion primtive : assertions) {
            QName qname = primtive.getName();
            if (!SP11Constants.HTTPS_TOKEN.equals(qname)) continue;
            HttpsToken httpsToken = new HttpsToken(1);
            String attr = ((PrimitiveAssertion)primtive).getAttribute(SPConstants.REQUIRE_CLIENT_CERTIFICATE);
            if (attr != null) {
                httpsToken.setRequireClientCertificate("true".equals(attr));
            }
            parent.setToken(httpsToken);
        }
    }
}

