/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.InitiatorToken;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.RecipientToken;
import org.apache.ws.secpolicy.model.SymmetricAsymmetricBindingBase;

public class AsymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private InitiatorToken initiatorToken;
    private RecipientToken recipientToken;

    public AsymmetricBinding(int version) {
        super(version);
    }

    public InitiatorToken getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setInitiatorToken(InitiatorToken initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    public RecipientToken getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(RecipientToken recipientToken) {
        this.recipientToken = recipientToken;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.ASYMMETRIC_BINDING;
        }
        return SP11Constants.ASYMMETRIC_BINDING;
    }

    @Override
    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List<Assertion> configs = algorithmSuite.getConfigurations();
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        Iterator<Assertion> iterator = configs.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            AsymmetricBinding asymmetricBinding = new AsymmetricBinding(this.version);
            asymmetricBinding.setAlgorithmSuite((AlgorithmSuite)iterator.next());
            asymmetricBinding.setEntireHeadersAndBodySignatures(this.isEntireHeadersAndBodySignatures());
            asymmetricBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            asymmetricBinding.setInitiatorToken(this.getInitiatorToken());
            asymmetricBinding.setLayout(this.getLayout());
            asymmetricBinding.setProtectionOrder(this.getProtectionOrder());
            asymmetricBinding.setRecipientToken(this.getRecipientToken());
            asymmetricBinding.setSignatureProtection(this.isSignatureProtection());
            asymmetricBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            asymmetricBinding.setTokenProtection(this.isTokenProtection());
            asymmetricBinding.setNormalized(true);
            wrapper.addPolicyComponent((PolicyComponent)wrapper);
        }
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        AsymmetricBinding.writeStartElement(writer, prefix, localname, namespaceURI);
        AsymmetricBinding.writeStartElement(writer, SPConstants.POLICY);
        if (this.initiatorToken == null) {
            throw new RuntimeException("InitiatorToken is not set");
        }
        this.initiatorToken.serialize(writer);
        if (this.recipientToken == null) {
            throw new RuntimeException("RecipientToken is not set");
        }
        this.recipientToken.serialize(writer);
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite is not set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            AsymmetricBinding.writeEmptyElement(writer, prefix, "IncludeTimestamp", namespaceURI);
        }
        if ("EncryptBeforeSigning".equals(this.getProtectionOrder())) {
            AsymmetricBinding.writeEmptyElement(writer, prefix, "EncryptBeforeSigning", namespaceURI);
        }
        if (this.isSignatureProtection()) {
            AsymmetricBinding.writeEmptyElement(writer, prefix, "EncryptSignature", namespaceURI);
        }
        if (this.isTokenProtection()) {
            AsymmetricBinding.writeEmptyElement(writer, prefix, "ProtectTokens", namespaceURI);
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            AsymmetricBinding.writeEmptyElement(writer, prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

