/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.server.core.request.JolokiaExecRequest;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;

public class ExecHandler
extends AbstractCommandHandler<JolokiaExecRequest> {
    @Override
    public RequestType getType() {
        return RequestType.EXEC;
    }

    @Override
    protected void checkForRestriction(JolokiaExecRequest pRequest) {
        if (!this.context.isOperationAllowed(pRequest.getObjectName(), pRequest.getOperation())) {
            throw new SecurityException("Operation " + pRequest.getOperation() + " forbidden for MBean " + pRequest.getObjectNameAsString());
        }
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaExecRequest request) throws InstanceNotFoundException, ReflectionException, MBeanException, IOException {
        OperationAndParamType types = this.extractOperationTypes(server, request);
        int nrParams = types.paramClasses.length;
        Object[] params = new Object[nrParams];
        List args = request.getArguments();
        this.verifyArguments(request, types, nrParams, args);
        for (int i = 0; i < nrParams; ++i) {
            params[i] = types.paramOpenTypes[i] != null ? ((Serializer)this.context.getMandatoryService(Serializer.class)).deserializeOpenType(types.paramOpenTypes[i], args.get(i)) : ((Serializer)this.context.getMandatoryService(Serializer.class)).deserialize(types.paramClasses[i], args.get(i));
        }
        return server.invoke(request.getObjectName(), types.operationName, params, types.paramClasses);
    }

    private void verifyArguments(JolokiaExecRequest request, OperationAndParamType pTypes, int pNrParams, List<Object> pArgs) {
        if (pNrParams > 0 && pArgs == null || pArgs != null && pArgs.size() != pNrParams) {
            throw new IllegalArgumentException("Invalid number of operation arguments. Operation " + request.getOperation() + " on " + String.valueOf(request.getObjectName()) + " requires " + pTypes.paramClasses.length + " parameters, not " + (pArgs == null ? 0 : pArgs.size()) + " as given");
        }
    }

    private OperationAndParamType extractOperationTypes(MBeanServerConnection pServer, JolokiaExecRequest pRequest) throws ReflectionException, InstanceNotFoundException, IOException {
        List<Object> types;
        if (pRequest.getOperation() == null) {
            throw new IllegalArgumentException("No operation given for exec Request on MBean " + String.valueOf(pRequest.getObjectName()));
        }
        List<String> opArgs = this.splitOperation(pRequest.getOperation());
        String operation = opArgs.get(0);
        if (opArgs.size() > 1) {
            types = opArgs.size() == 2 && opArgs.get(1) == null ? Collections.emptyList() : opArgs.subList(1, opArgs.size());
        } else {
            List<MBeanParameterInfo[]> paramInfos = this.extractMBeanParameterInfos(pServer, pRequest, operation);
            if (paramInfos.size() == 1) {
                return new OperationAndParamType(operation, paramInfos.get(0));
            }
            throw new IllegalArgumentException(this.getErrorMessageForMissingSignature(pRequest, operation, paramInfos));
        }
        List<MBeanParameterInfo[]> paramInfos = this.extractMBeanParameterInfos(pServer, pRequest, operation);
        MBeanParameterInfo[] matchingSignature = this.getMatchingSignature(types, paramInfos);
        if (matchingSignature == null) {
            throw new IllegalArgumentException("No operation " + pRequest.getOperation() + " on MBean " + pRequest.getObjectNameAsString() + " exists. Known signatures: " + this.signatureToString(paramInfos));
        }
        return new OperationAndParamType(operation, matchingSignature);
    }

    private List<MBeanParameterInfo[]> extractMBeanParameterInfos(MBeanServerConnection pServer, JolokiaExecRequest pRequest, String pOperation) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            MBeanInfo mBeanInfo = pServer.getMBeanInfo(pRequest.getObjectName());
            ArrayList<MBeanParameterInfo[]> paramInfos = new ArrayList<MBeanParameterInfo[]>();
            for (MBeanOperationInfo opInfo : mBeanInfo.getOperations()) {
                if (!opInfo.getName().equals(pOperation)) continue;
                paramInfos.add(opInfo.getSignature());
            }
            if (paramInfos.isEmpty()) {
                throw new IllegalArgumentException("No operation " + pOperation + " found on MBean " + pRequest.getObjectNameAsString());
            }
            return paramInfos;
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Cannot extract MBeanInfo for " + pRequest.getObjectNameAsString(), e);
        }
    }

    private MBeanParameterInfo[] getMatchingSignature(List<String> pTypes, List<MBeanParameterInfo[]> pParamInfos) {
        block0: for (MBeanParameterInfo[] infos : pParamInfos) {
            if (infos.length == 0 && pTypes.isEmpty()) {
                return infos;
            }
            if (pTypes.size() != infos.length) continue;
            for (int i = 0; i < infos.length; ++i) {
                String type = infos[i].getType();
                if (!type.equals(pTypes.get(i))) continue block0;
            }
            return infos;
        }
        return null;
    }

    private List<String> splitOperation(String pOperation) {
        ArrayList<String> ret = new ArrayList<String>();
        Pattern p = Pattern.compile("^(.*)\\((.*)\\)$");
        Matcher m = p.matcher(pOperation);
        if (m.matches()) {
            ret.add(m.group(1));
            if (!m.group(2).isEmpty()) {
                String[] args = m.group(2).split("\\s*,\\s*");
                ret.addAll(Arrays.asList(args));
            } else {
                ret.add(null);
            }
        } else {
            ret.add(pOperation);
        }
        return ret;
    }

    private String getErrorMessageForMissingSignature(JolokiaExecRequest pRequest, String pOperation, List<MBeanParameterInfo[]> pParamInfos) {
        StringBuilder msg = new StringBuilder("Operation ");
        msg.append(pOperation).append(" on MBean ").append(pRequest.getObjectNameAsString()).append(" is overloaded. Signatures found: ");
        msg.append(this.signatureToString(pParamInfos));
        msg.append(". Use a signature when specifying the operation.");
        return msg.toString();
    }

    private String signatureToString(List<MBeanParameterInfo[]> pParamInfos) {
        StringBuilder ret = new StringBuilder();
        for (MBeanParameterInfo[] ii : pParamInfos) {
            ret.append("(");
            for (MBeanParameterInfo i : ii) {
                ret.append(i.getType()).append(",");
            }
            ret.setLength(ret.length() - 1);
            ret.append("),");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    private static final class OperationAndParamType {
        private final String operationName;
        private final String[] paramClasses;
        private final OpenType<?>[] paramOpenTypes;

        private OperationAndParamType(String pOperationName, MBeanParameterInfo[] pParameterInfos) {
            this.operationName = pOperationName;
            this.paramClasses = new String[pParameterInfos.length];
            this.paramOpenTypes = new OpenType[pParameterInfos.length];
            int i = 0;
            for (MBeanParameterInfo info : pParameterInfos) {
                if (info instanceof OpenMBeanParameterInfo) {
                    OpenMBeanParameterInfo openTypeInfo = (OpenMBeanParameterInfo)((Object)info);
                    this.paramOpenTypes[i] = openTypeInfo.getOpenType();
                }
                this.paramClasses[i++] = info.getType();
            }
        }
    }
}

