/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.tools.DiagnosticListener;
import org.openjdk.javax.tools.JavaCompiler;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.source.util.JavacTask;
import org.openjdk.tools.javac.Main;
import org.openjdk.tools.javac.api.ClientCodeWrapper;
import org.openjdk.tools.javac.api.JavacTaskImpl;
import org.openjdk.tools.javac.file.BaseFileManager;
import org.openjdk.tools.javac.file.CacheFSInfo;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.jvm.Target;
import org.openjdk.tools.javac.main.Arguments;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.util.ClientCodeException;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.PropagatedException;

public final class JavacTool
implements JavaCompiler {
    @Deprecated
    public JavacTool() {
    }

    @Override
    public String name() {
        return "javac";
    }

    public static JavacTool create() {
        return new JavacTool();
    }

    @Override
    public JavacFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        Context context = new Context();
        context.put(Locale.class, locale);
        if (diagnosticListener != null) {
            context.put(DiagnosticListener.class, diagnosticListener);
        }
        PrintWriter printWriter = charset == null ? new PrintWriter(System.err, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, charset), true);
        context.put(Log.errKey, printWriter);
        CacheFSInfo.preRegister(context);
        return new JavacFileManager(context, true, charset);
    }

    @Override
    public JavacTask getTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3) {
        Context context = new Context();
        return this.getTask(writer, javaFileManager, diagnosticListener, iterable, iterable2, iterable3, context);
    }

    /*
     * WARNING - void declaration
     */
    public JavacTask getTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3, Context context) {
        try {
            ClientCodeWrapper clientCodeWrapper = ClientCodeWrapper.instance(context);
            if (iterable != null) {
                for (String object : iterable) {
                    Objects.requireNonNull(object);
                }
            }
            if (iterable2 != null) {
                for (String string : iterable2) {
                    void var10_16;
                    int n = string.indexOf(47);
                    if (n > 0) {
                        String string2 = string.substring(0, n);
                        if (!SourceVersion.isName(string2)) {
                            throw new IllegalArgumentException("Not a valid module name: " + string2);
                        }
                        String string3 = string.substring(n + 1);
                    }
                    if (SourceVersion.isName((CharSequence)var10_16)) continue;
                    throw new IllegalArgumentException("Not a valid class name: " + (String)var10_16);
                }
            }
            if (iterable3 != null) {
                iterable3 = clientCodeWrapper.wrapJavaFileObjects(iterable3);
                for (JavaFileObject javaFileObject : iterable3) {
                    if (javaFileObject.getKind() == JavaFileObject.Kind.SOURCE) continue;
                    String string = "Compilation unit is not of SOURCE kind: \"" + javaFileObject.getName() + "\"";
                    throw new IllegalArgumentException(string);
                }
            }
            if (diagnosticListener != null) {
                context.put(DiagnosticListener.class, clientCodeWrapper.wrap(diagnosticListener));
            }
            if (writer == null) {
                context.put(Log.errKey, new PrintWriter(System.err, true));
            } else {
                context.put(Log.errKey, new PrintWriter(writer, true));
            }
            if (javaFileManager == null && (javaFileManager = this.getStandardFileManager((DiagnosticListener)diagnosticListener, (Locale)null, (Charset)null)) instanceof BaseFileManager) {
                ((BaseFileManager)javaFileManager).autoClose = true;
            }
            javaFileManager = clientCodeWrapper.wrap(javaFileManager);
            context.put(JavaFileManager.class, javaFileManager);
            Arguments arguments = Arguments.instance(context);
            arguments.init("javac", iterable, iterable2, iterable3);
            if (javaFileManager.isSupportedOption(Option.MULTIRELEASE.primaryName) == 1) {
                Target target = Target.instance(context);
                List<String> list = List.of(target.multiReleaseValue());
                javaFileManager.handleOption(Option.MULTIRELEASE.primaryName, list.iterator());
            }
            return new JavacTaskImpl(context);
        }
        catch (PropagatedException propagatedException) {
            throw propagatedException.getCause();
        }
        catch (ClientCodeException clientCodeException) {
            throw new RuntimeException(clientCodeException.getCause());
        }
    }

    @Override
    public int run(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, String ... stringArray) {
        if (outputStream2 == null) {
            outputStream2 = System.err;
        }
        for (String string : stringArray) {
            Objects.requireNonNull(string);
        }
        return Main.compile(stringArray, new PrintWriter(outputStream2, true));
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(EnumSet.range(SourceVersion.RELEASE_3, SourceVersion.latest()));
    }

    @Override
    public int isSupportedOption(String string) {
        Set<Option> set = Option.getJavacToolOptions();
        for (Option option : set) {
            if (!option.matches(string)) continue;
            return option.hasArg() ? 1 : 0;
        }
        return -1;
    }
}

